/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.selection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.renderer.selection.AbstractSelection;
import org.openscience.cdk.renderer.selection.IChemObjectSelection;

public class SingleSelection<T extends IChemObject>
extends AbstractSelection
implements IChemObjectSelection {
    T selection;

    public SingleSelection(T item) {
        this.selection = item;
    }

    @Override
    public IAtomContainer getConnectedAtomContainer() {
        IAtomContainer ac = (IAtomContainer)this.selection.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        this.addToAtomContainer(ac, (IChemObject)this.selection);
        return ac;
    }

    @Override
    public boolean isFilled() {
        return this.selection != null;
    }

    @Override
    public boolean contains(IChemObject obj) {
        return this.selection == obj;
    }

    @Override
    public <E extends IChemObject> Collection<E> elements(Class<E> clazz) {
        if (this.selection == null) {
            return Collections.emptySet();
        }
        HashSet<T> set = new HashSet<T>();
        set.add(this.selection);
        return set;
    }
}

