/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.undoredo;

import java.util.Iterator;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.undoredo.IUndoRedoable;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class RemoveAtomsAndBondsEdit
implements IUndoRedoable {
    private static final long serialVersionUID = -143712173063846054L;
    private String type;
    private IAtomContainer undoRedoContainer;
    private IChemModel chemModel;
    private IAtomContainer container;
    private IChemModelRelay chemModelRelay = null;

    public RemoveAtomsAndBondsEdit(IChemModel chemModel, IAtomContainer undoRedoContainer, String type, IChemModelRelay chemModelRelay) {
        this.chemModel = chemModel;
        this.undoRedoContainer = undoRedoContainer;
        this.container = (IAtomContainer)chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        Iterator containers = ChemModelManipulator.getAllAtomContainers((IChemModel)chemModel).iterator();
        while (containers.hasNext()) {
            this.container.add((IAtomContainer)containers.next());
        }
        this.type = type;
        this.chemModelRelay = chemModelRelay;
    }

    @Override
    public void redo() {
        int i;
        for (i = 0; i < this.undoRedoContainer.getBondCount(); ++i) {
            IBond bond = this.undoRedoContainer.getBond(i);
            this.container.removeBond(bond);
        }
        for (i = 0; i < this.undoRedoContainer.getAtomCount(); ++i) {
            IAtom atom = this.undoRedoContainer.getAtom(i);
            this.container.removeAtom(atom);
        }
        this.chemModelRelay.updateAtoms(this.container, this.container.atoms());
        IMolecule molecule = (IMolecule)this.container.getBuilder().newInstance(IMolecule.class, new Object[]{this.container});
        IMoleculeSet moleculeSet = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)molecule);
        this.chemModel.setMoleculeSet(moleculeSet);
    }

    @Override
    public void undo() {
        int i;
        for (i = 0; i < this.undoRedoContainer.getBondCount(); ++i) {
            IBond bond = this.undoRedoContainer.getBond(i);
            this.container.addBond(bond);
        }
        for (i = 0; i < this.undoRedoContainer.getAtomCount(); ++i) {
            IAtom atom = this.undoRedoContainer.getAtom(i);
            this.container.addAtom(atom);
        }
        this.chemModelRelay.updateAtoms(this.container, this.container.atoms());
        IMolecule molecule = (IMolecule)this.container.getBuilder().newInstance(IMolecule.class, new Object[]{this.container});
        IMoleculeSet moleculeSet = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)molecule);
        this.chemModel.setMoleculeSet(moleculeSet);
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    public String getPresentationName() {
        return this.type;
    }
}

