/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.generators.BasicBondGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.SelectAtomGenerator;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;
import org.openscience.cdk.renderer.selection.IChemObjectSelection;
import org.openscience.cdk.renderer.selection.IncrementalSelection;

public class SelectBondGenerator
extends BasicBondGenerator {
    private SelectionBondColor selectionBondColor = new SelectionBondColor();
    private boolean autoUpdateSelection = true;

    @Override
    public IRenderingElement generate(IAtomContainer ac, RendererModel model) {
        IncrementalSelection sel;
        IAtomContainer selectedAC;
        Color selectionColor = (Color)model.getParameter(SelectionBondColor.class).getValue();
        IChemObjectSelection selection = model.getSelection();
        ElementGroup selectionElements = new ElementGroup();
        if (selection == null) {
            return selectionElements;
        }
        if ((this.autoUpdateSelection || selection.isFilled()) && (selectedAC = selection.getConnectedAtomContainer()) != null) {
            super.setOverrideColor(selectionColor);
            super.setOverrideBondWidth((Double)model.getParameter(SelectAtomGenerator.SelectionRadius.class).getValue());
            selectionElements.add(super.generate(selectedAC, model));
        }
        if (selection instanceof IncrementalSelection && !(sel = (IncrementalSelection)selection).isFinished()) {
            selectionElements.add(sel.generate(selectionColor));
        }
        return selectionElements;
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(this.selectionBondColor);
    }

    public static class SelectionBondColor
    extends AbstractGeneratorParameter<Color> {
        @Override
        public Color getDefault() {
            return Color.LIGHT_GRAY;
        }
    }
}

