/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.edit;

import java.util.Set;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.controller.edit.IEdit;
import org.openscience.cdk.controller.edit.SetStereo;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class SetBondOrder
extends AbstractEdit {
    IBond bond;
    IBond.Order newOrder;
    IBond.Order oldOrder;

    public static IEdit cycleBondValence(IBond bond) {
        IBond.Order maxOrder = IBond.Order.TRIPLE;
        if (bond.getStereo() != IBond.Stereo.NONE) {
            return SetStereo.setStereo(bond, IBond.Stereo.NONE);
        }
        IBond.Order order = BondManipulator.isLowerOrder((IBond.Order)bond.getOrder(), (IBond.Order)maxOrder) ? BondManipulator.increaseBondOrder((IBond.Order)bond.getOrder()) : IBond.Order.SINGLE;
        return new SetBondOrder(bond, order);
    }

    public static SetBondOrder setOrder(IBond bond, IBond.Order order) {
        return new SetBondOrder(bond, order);
    }

    private SetBondOrder(IBond bond, IBond.Order order) {
        this.bond = bond;
        this.newOrder = order;
        this.oldOrder = bond.getOrder();
    }

    @Override
    public void redo() {
        this.bond.setOrder(this.newOrder);
        this.updateHydrogenCount(this.bond.getAtom(0), this.bond.getAtom(1));
    }

    @Override
    public void undo() {
        this.bond.setOrder(this.oldOrder);
        this.updateHydrogenCount(this.bond.getAtom(0), this.bond.getAtom(1));
    }

    @Override
    public Set<Changed> getTypeOfChanges() {
        return SetBondOrder.changed(Changed.Properties);
    }
}

