/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.periodictable;

import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.tools.periodictable.PeriodicTableElementTest")
class PeriodicTableElement
implements Cloneable {
    private static final long serialVersionUID = -2508810950266128526L;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(PeriodicTableElement.class);
    protected String name;
    protected String chemicalSerie;
    protected Integer period = (Integer)CDKConstants.UNSET;
    protected Integer group = (Integer)CDKConstants.UNSET;
    protected String phase;
    protected String casId;
    protected Double vdwRadius = (Double)CDKConstants.UNSET;
    protected Double covalentRadius = (Double)CDKConstants.UNSET;
    protected Double paulingEneg = (Double)CDKConstants.UNSET;
    private Integer atomicNumber = (Integer)CDKConstants.UNSET;
    private String symbol;

    @TestMethod(value="testConstructor")
    public PeriodicTableElement(String symbol) {
        this.symbol = symbol;
    }

    @TestMethod(value="testConstructor")
    public PeriodicTableElement(String symbol, Integer atomicNumber) {
        this.symbol = symbol;
        this.atomicNumber = atomicNumber;
    }

    @TestMethod(value="testGetSymbol")
    public String getSymbol() {
        return this.symbol;
    }

    @TestMethod(value="testSetSymbol")
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @TestMethod(value="testGetName")
    public String getName() {
        return this.name;
    }

    @TestMethod(value="testSetName")
    public void setName(String name) {
        this.name = name;
    }

    @TestMethod(value="testGetSeries")
    public String getChemicalSerie() {
        return this.chemicalSerie;
    }

    @TestMethod(value="testSetSeries")
    public void setChemicalSerie(String chemicalSerie) {
        this.chemicalSerie = chemicalSerie;
    }

    @TestMethod(value="testGetPeriod")
    public Integer getPeriod() {
        return this.period;
    }

    @TestMethod(value="testSetPeriod")
    public void setPeriod(Integer period) {
        this.period = period;
    }

    @TestMethod(value="testGetGroup")
    public Integer getGroup() {
        return this.group;
    }

    @TestMethod(value="testSetGroup")
    public void setGroup(Integer group) throws CDKException {
        if (group < 1 || group > 18) {
            throw new CDKException("Invalid group number specified. Must be between 1 and 18");
        }
        this.group = group;
    }

    @TestMethod(value="testGetPhase")
    public String getPhase() {
        return this.phase;
    }

    @TestMethod(value="testSetPhase")
    public void setPhase(String phase) {
        this.phase = phase;
    }

    @TestMethod(value="testGetCASid")
    public String getCASid() {
        return this.casId;
    }

    @TestMethod(value="testSetCASid")
    public void setCASid(String casId) {
        this.casId = casId;
    }

    @TestMethod(value="testGetVdw")
    public Double getVdwRadius() {
        return this.vdwRadius;
    }

    @TestMethod(value="testSetVdw")
    public void setVdwRadius(Double vdwRadius) {
        this.vdwRadius = vdwRadius;
    }

    @TestMethod(value="testGetCovalentRadius")
    public Double getCovalentRadius() {
        return this.covalentRadius;
    }

    @TestMethod(value="testSetCovalentRadius")
    public void setCovalentRadius(Double covalentRadius) {
        this.covalentRadius = covalentRadius;
    }

    @TestMethod(value="testGetEneg")
    public Double getPaulingEneg() {
        return this.paulingEneg;
    }

    @TestMethod(value="testSetEneg")
    public void setPaulingEneg(Double paulingEneg) {
        this.paulingEneg = paulingEneg;
    }

    @TestMethod(value="testClone")
    public Object clone() throws CloneNotSupportedException {
        PeriodicTableElement clone = null;
        try {
            clone = (PeriodicTableElement)super.clone();
            clone.setSymbol(this.symbol);
            clone.setAtomicNumber(this.atomicNumber);
            clone.setChemicalSerie(this.chemicalSerie);
            clone.setCASid(this.casId);
            clone.setCovalentRadius(this.covalentRadius);
            clone.setGroup(this.group);
            clone.setName(this.name);
            clone.setPaulingEneg(this.paulingEneg);
            clone.setPeriod(this.period);
            clone.setPhase(this.phase);
            clone.setVdwRadius(this.vdwRadius);
        }
        catch (Exception exception) {
            logger.debug(exception);
        }
        return clone;
    }

    @TestMethod(value="testGetSetAtomicNumber")
    public Integer getAtomicNumber() {
        return this.atomicNumber;
    }

    @TestMethod(value="testGetSetAtomicNumber")
    public void setAtomicNumber(Integer atomicNumber) {
        this.atomicNumber = atomicNumber;
    }

    @TestMethod(value="testString")
    public String toString() {
        StringBuffer resultString = new StringBuffer(128);
        resultString.append("PeriodicTableElement(");
        resultString.append(this.getSymbol());
        resultString.append(", AN:");
        resultString.append(this.getAtomicNumber());
        resultString.append(", N:");
        resultString.append(this.getName());
        resultString.append(", CS:");
        resultString.append(this.getChemicalSerie());
        resultString.append(", P:");
        resultString.append(this.getPeriod());
        resultString.append(", G:");
        resultString.append(this.getGroup());
        resultString.append(", Ph:");
        resultString.append(this.getPhase());
        resultString.append(", CAS:");
        resultString.append(this.getCASid());
        resultString.append(", VdW:");
        resultString.append(this.getVdwRadius());
        resultString.append(", Cov:");
        resultString.append(this.getCovalentRadius());
        resultString.append(", Eneg:");
        resultString.append(this.getPaulingEneg());
        resultString.append(')');
        return resultString.toString();
    }
}

