/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.app;

import org.guha.rcdk.util.Misc;
import org.guha.rcdk.view.MoleculeImageToClipboard;
import org.guha.rcdk.view.RcdkDepictor;
import org.guha.rcdk.view.ViewMolecule2D;
import org.guha.rcdk.view.ViewMolecule2DTable;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.SmilesParser;

public class OSXHelper {
    private static RcdkDepictor depictor;

    public void copyToClipboard(IAtomContainer molecule, int width, int height) throws Exception {
        MoleculeImageToClipboard.copyImageToClipboard(molecule, depictor);
    }

    public void viewMolecule2D(IAtomContainer molecule) throws Exception {
        ViewMolecule2D v = new ViewMolecule2D(molecule, depictor);
        v.draw();
    }

    public void viewMoleculeTable(IAtomContainer[] mols, int ncol, int cellx, int celly) throws Exception {
        ViewMolecule2DTable v = new ViewMolecule2DTable(mols, ncol, cellx, celly, depictor);
    }

    public static void main(String[] args) throws Exception {
        String method = args[0];
        String smiles = args[1];
        int width = Integer.parseInt(args[2]);
        int height = Integer.parseInt(args[3]);
        double zoom = Double.parseDouble(args[4]);
        String style = args[5];
        String annotate = args[6];
        String abbr = args[7];
        boolean suppressh = args[8].equals("TRUE");
        boolean showTitle = args[9].equals("TRUE");
        int smaLimit = Integer.parseInt(args[10]);
        String sma = args[11];
        depictor = new RcdkDepictor(width, height, zoom, style, annotate, abbr, suppressh, showTitle, smaLimit, sma);
        int ncol = -1;
        if (args.length == 13) {
            ncol = Integer.parseInt(args[12]);
        }
        if (smiles != null && !smiles.equals("")) {
            OSXHelper helper = new OSXHelper();
            SmilesParser sp = new SmilesParser(DefaultChemObjectBuilder.getInstance());
            if (method.equals("copyToClipboard")) {
                IAtomContainer mol = sp.parseSmiles(smiles);
                helper.copyToClipboard(mol, width, height);
            } else if (method.equals("viewMolecule2D")) {
                IAtomContainer mol = sp.parseSmiles(smiles);
                helper.viewMolecule2D(mol);
            } else if (method.equals("viewMolecule2Dtable")) {
                IAtomContainer[] mols = Misc.loadMolecules(new String[]{smiles}, true, true, true);
                helper.viewMoleculeTable(mols, ncol, width, height);
            } else {
                System.out.println("Didn't recognize method to run");
            }
        } else {
            System.out.println("Didn't get a SMILES to process");
        }
    }
}

