/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view;

import org.guha.rcdk.util.Misc;
import org.guha.rcdk.view.StructureTable2D;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class ViewMolecule2DTable {
    public ViewMolecule2DTable(IAtomContainer[] molecules, int ncol, int cellx, int celly) {
        boolean showH = false;
        try {
            IAtomContainer[] v = new IAtomContainer[molecules.length];
            for (int i = 0; i < v.length; ++i) {
                StructureDiagramGenerator sdg = new StructureDiagramGenerator();
                sdg.setMolecule((IMolecule)AtomContainerManipulator.removeHydrogens((IAtomContainer)molecules[i]));
                sdg.generateCoordinates();
                v[i] = sdg.getMolecule();
                CDKHueckelAromaticityDetector.detectAromaticity((IAtomContainer)v[i]);
            }
            if (v.length < ncol) {
                StructureTable2D st = new StructureTable2D(v, v.length, cellx, celly, showH);
                st.display();
            } else {
                StructureTable2D st = new StructureTable2D(v, ncol, cellx, celly, showH);
                st.display();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void main(String[] args) {
        String[] fname = new String[]{"/Users/rguha/src/R/trunk/rcdk/data/dan001.hin", "/Users/rguha/src/R/trunk/rcdk/data/dan002.hin", "/Users/rguha/src/R/trunk/rcdk/data/dan008.hin"};
        IAtomContainer[] acs = null;
        try {
            acs = Misc.loadMolecules(fname);
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
        ViewMolecule2DTable v2dt = new ViewMolecule2DTable(acs, 3, 200, 200);
    }
}

