/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.dialogs;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.applications.jchempaint.JChemPaintEditorPanel;
import org.openscience.cdk.applications.swing.DictRefEditorTableModel;

public class EditDictRefs
extends JFrame {
    private static final long serialVersionUID = 1835058218886715502L;
    DictRefEditorTableModel tableModel;

    public EditDictRefs() {
        super("Edit Dictionary References");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel southPanel = new JPanel();
        JButton cancelButton = new JButton("Cancel");
        JButton applyButton = new JButton("Apply");
        applyButton.addActionListener(new ApplyAction());
        cancelButton.addActionListener(new CancelAction());
        southPanel.add(applyButton);
        southPanel.add(cancelButton);
        this.tableModel = new DictRefEditorTableModel();
        JTable table = new JTable((TableModel)this.tableModel);
        table.setPreferredSize(new Dimension(500, 300));
        TableColumn dictColumn = table.getColumnModel().getColumn(1);
        JComboBox<String> comboBox = new JComboBox<String>();
        String[] dicts = JChemPaintEditorPanel.getDictionaryDatabase().getDictionaryNames();
        for (int i = 0; i < dicts.length; ++i) {
            comboBox.addItem(dicts[i]);
        }
        dictColumn.setCellEditor(new DefaultCellEditor(comboBox));
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setPreferredSize(new Dimension(500, 100));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", scrollPane);
        this.getContentPane().add("South", southPanel);
    }

    public void setChemObject(ChemObject object) {
        this.tableModel.setChemObject(object);
    }

    public void closeFrame() {
        this.dispose();
    }

    class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -3203480495994212236L;

        CancelAction() {
            super("Cancel");
        }

        public void actionPerformed(ActionEvent e) {
            EditDictRefs.this.closeFrame();
        }
    }

    class ApplyAction
    extends AbstractAction {
        private static final long serialVersionUID = -5199060935605242223L;

        ApplyAction() {
            super("Apply");
        }

        public void actionPerformed(ActionEvent e) {
        }
    }
}

