% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lt.R
\name{lt}
\alias{leadtime}
\alias{lt}
\title{Lead time from one date to another}
\usage{
lt(from, to, neg = NA, as = "numeric")

leadtime(from, to, neg = NA, as = "numeric")
}
\arguments{
\item{from, to}{start and stop dates (in formats that can be coerced by
\code{\link{as.Dates}}).}

\item{neg}{default value for negative lead times. \code{NULL} means that 
negative lead times are kept as is. \code{NA} by default (changes
negative values to \code{NA}). Any numerical value is accepted}

\item{as}{name of the class to be assigned to x. Default is \code{numeric}
but could also be set to for example \code{\link{difftime}} or \code{\link{integer}}.}
}
\value{
A vector of class \code{as} (\code{numeric} by default).
}
\description{
Lead time from one date to another
}
\examples{
lt(from = Sys.Date(), to = Sys.Date() + 10)
}

