% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvec.R
\name{canvec.export}
\alias{canvec.export}
\title{Export CanVec Data}
\usage{
canvec.export(ntsid, tofolder, layers = NULL, crs = NULL, cachedir = NULL,
  driver = NULL, combine = TRUE, overwrite = TRUE, ...)
}
\arguments{
\item{ntsid}{One or more NTS References as generated by \code{nts()}}

\item{tofolder}{A directory to which files should be copied.}

\item{layers}{One or more layer ids as listed in \code{canvec_layers$id}. Defaults to
all layers.}

\item{crs}{A CRS (as generated by \code{sp::CRS()}) in which to project the data.}

\item{cachedir}{Pass a specific cache directory in which files have been extracted.
Default value is that returned by \code{canvec.cachedir()}}

\item{driver}{A \code{rgdal} driver with which to save data. \code{ESRI Shapefile},
\code{KML}, \code{CSV}, and \code{GML} have been tested; others returned by
\code{rgdal::ogrDrivers()} may also work.}

\item{combine}{\code{TRUE} if output should be one file per layer, \code{FALSE} otherwise}

\item{overwrite}{\code{TRUE} if files should overwrite files already in output directory.}

\item{...}{Arguments passed on to \code{sp::writeOGR()}}
}
\description{
Export \code{layers} for one or more NTS reference(s) \code{ntsid} to path \code{tofolder}, 
automatically renaming layers based on their layerid. Pass \code{crs} to re-project data,
or pass \code{driver} to convert file format.
}
\examples{
\donttest{
canvec.download(nts("21h01"))
canvec.export(nts("21h01"), "exporteddata", layers=c("road", "river"))
canvec.export(nts("21h01"), "exporteddataUTM", layers=c("road", "river"), 
                 crs=sp::CRS("+init=epsg:26920"))
canvec.export(nts("21h01"), "exporteddata", layers=c("road", "river"), 
               driver="KML")
canvec.export(nts("21h01"), "exporteddataALL")
}

}

