% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_glyphs.R
\name{ly_arc}
\alias{ly_arc}
\title{Add an "arc" layer to a Bokeh figure}
\usage{
ly_arc(fig, x, y = NULL, data = figure_data(fig), color = NULL,
  alpha = 1, width = 2, type = 1, radius = 0.2, start_angle = 0,
  end_angle = 2 * pi, direction = "anticlock", legend = NULL,
  lname = NULL, lgroup = NULL, visible = TRUE, ...)
}
\arguments{
\item{fig}{figure to modify}

\item{x}{values or field name of center x coordinates}

\item{y}{values or field name of center y coordinates}

\item{data}{an optional data frame, providing the source for inputs x, y, and other glyph properties}

\item{color}{color to use to stroke lines with - a hex code (with no alpha) or any of the 147 named CSS colors, e.g 'green', 'indigo'}

\item{alpha}{transparency value for the line between 0 (transparent) and 1 (opaque)}

\item{width}{stroke width in units of pixels}

\item{type}{an integer between 1 and 6 matching the \code{lty} property in \code{\link[graphics]{par}} or an array of integer pixel distances that describe the on-off pattern of dashing to use}

\item{radius}{values or field name of arc radii}

\item{start_angle}{values or field name of starting angles}

\item{end_angle}{values or field name of ending angles}

\item{direction}{direction to turn between starting and ending angles ("anticlock", "clock")}

\item{legend}{either a logical specifying not to plot a legend for this layer (FALSE) or a string indicating the name of the legend entry for this layer (note that when mapping plot attributes to variables in \code{data}, a legend is automatically created and does not need to be specified - see "Mapped plot attributes and legends" below)}

\item{lname}{layer name}

\item{lgroup}{layer group}

\item{visible}{should the layer be visible?}

\item{\ldots}{additional parameters for fine control over line properties (see "Additional parameters" below)}
}
\description{
Add an "arc" layer to a Bokeh figure
}
\section{Mapped plot attributes and legends}{
 When specifying an input data frame for a layer through the \code{data} argument, columns of \code{data} can be used to specify various plot attributes such as \code{color}, etc. For example, with \code{ly_points(..., data = iris, color = Species)}, the \code{Species} variable is used to determine how to color the points.  Here, \code{Species} is "mapped" to the \code{color} attribute.  Both continuous and categorical variables can be mapped.  In the case of continuous variables, the range is cut into slices and attributes are applied to each interval.  The mapping from the values of the variable to the actual plot attributes is determined based on the theme.
}

\section{Additional parameters}{

\tabular{ll}{
  \code{line_join} \tab how path segments should be joined together 'miter' 'round' 'bevel' \cr
  \code{line_cap} \tab how path segments should be terminated 'butt' 'round' 'square' \cr
  \code{line_dash} \tab an integer between 1 and 6 matching the \code{lty} property in \code{\link[graphics]{par}} or an array of integer pixel distances that describe the on-off pattern of dashing to use \cr
  \code{line_dash_offset} \tab the distance in pixels into the line_dash that the pattern should start from
 }
}
\examples{
\donttest{
rescale <- function(x) {
  (x - min(x)) / diff(range(x))
}

figure() \%>\%
  ly_annular_wedge(Sepal.Length, Sepal.Width, data = iris,
    end_angle = rescale(Petal.Length)*2*pi, color = Species,
    inner_radius = 0.1, outer_radius = 0.15, alpha = 0.5,
    hover = Species)

figure() \%>\%
  ly_wedge(Sepal.Length, Sepal.Width, data = iris,
    end_angle = rescale(Petal.Length)*2*pi, color = Species,
    radius = 0.15, alpha = 0.5,
    hover = Species)

figure() \%>\%
  ly_arc(Sepal.Length, Sepal.Width, data = iris,
    end_angle = rescale(Petal.Length)*2*pi, color = Species,
    alpha = 0.5)

figure() \%>\%
  ly_annulus(Sepal.Length, Sepal.Width, data = iris,
    color = Species, hover = Species, alpha = 0.5,
    outer_radius = rescale(Petal.Length) * 0.3,
    inner_radius = rescale(Petal.Length) * 0.1)
}
}
\seealso{
Other layer functions: \code{\link{ly_abline}},
  \code{\link{ly_annular_wedge}}, \code{\link{ly_annulus}},
  \code{\link{ly_bar}}, \code{\link{ly_bezier}},
  \code{\link{ly_boxplot}}, \code{\link{ly_contour}},
  \code{\link{ly_crect}}, \code{\link{ly_curve}},
  \code{\link{ly_density}}, \code{\link{ly_hist}},
  \code{\link{ly_image_url}}, \code{\link{ly_image}},
  \code{\link{ly_lines}}, \code{\link{ly_map}},
  \code{\link{ly_multi_line}}, \code{\link{ly_oval}},
  \code{\link{ly_patch}}, \code{\link{ly_points}},
  \code{\link{ly_polygons}}, \code{\link{ly_quadratic}},
  \code{\link{ly_quantile}}, \code{\link{ly_ray}},
  \code{\link{ly_rect}}, \code{\link{ly_segments}},
  \code{\link{ly_text}}, \code{\link{ly_wedge}}
}

