% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.R
\name{pool}
\alias{pool}
\alias{as.data.frame.pool}
\alias{print.pool}
\title{Pool analysis results obtained from the imputed datasets}
\usage{
pool(
  results,
  conf.level = 0.95,
  alternative = c("two.sided", "less", "greater"),
  type = c("percentile", "normal")
)

\method{as.data.frame}{pool}(x, ...)

\method{print}{pool}(x, ...)
}
\arguments{
\item{results}{an analysis object created by \code{\link[=analyse]{analyse()}}.}

\item{conf.level}{confidence level of the returned confidence interval.
Must be a single number between 0 and 1. Default is 0.95.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{type}{a character string of either \code{"percentile"} (default) or
\code{"normal"}. Determines what method should be used to calculate the bootstrap confidence
intervals. See details.
Only used if \code{method_condmean(type = "bootstrap")} was specified
in the original call to \code{\link[=draws]{draws()}}.}

\item{x}{a \code{pool} object generated by \code{\link[=pool]{pool()}}.}

\item{...}{not used.}
}
\description{
Pool analysis results obtained from the imputed datasets
}
\details{
The calculation used to generate the point estimate, standard errors and
confidence interval depends upon the method specified in the original
call to \code{\link[=draws]{draws()}}; In particular:
\itemize{
\item \code{method_approxbayes()} & \code{method_bayes()} both use Rubin's rules to pool estimates
and variances across multiple imputed datasets, and the Barnard-Rubin rule to pool
degree's of freedom; see Little & Rubin (2002).
\item \code{method_condmean(type = "bootstrap")} uses percentile or normal approximation;
see Efron & Tibshirani (1994). Note that for the percentile bootstrap, no standard error is
calculated, i.e. the standard errors will be \code{NA} in the object / \code{data.frame}.
\item \code{method_condmean(type = "jackknife")} uses the standard jackknife variance formula;
see Efron & Tibshirani (1994).
\item \code{method_bmlmi} uses pooling procedure for Bootstrapped Maximum Likelihood MI (BMLMI).
See Von Hippel & Bartlett (2021).
}
}
\references{
Bradley Efron and Robert J Tibshirani. An introduction to the bootstrap. CRC
press, 1994. [Section 11]

Roderick J. A. Little and Donald B. Rubin. Statistical Analysis with Missing
Data, Second Edition. John Wiley & Sons, Hoboken, New Jersey, 2002. [Section 5.4]

Von Hippel, Paul T and Bartlett, Jonathan W.
Maximum likelihood multiple imputation: Faster imputations and consistent standard
errors without posterior draws. 2021.
}
