% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_proteins.R
\name{rba_uniprot_proteins_search}
\alias{rba_uniprot_proteins_search}
\title{Search UniProt entries}
\usage{
rba_uniprot_proteins_search(
  accession = NULL,
  reviewed = NULL,
  isoform = NULL,
  go_term = NULL,
  keyword = NULL,
  ec = NULL,
  gene = NULL,
  exact_gene = NULL,
  protein = NULL,
  organism = NULL,
  taxid = NULL,
  pubmed = NULL,
  seq_length = NULL,
  md5 = NULL,
  ...
)
}
\arguments{
\item{accession}{\href{https://www.uniprot.org/help/accession_numbers}{
UniProtKB primary or secondary accession}(s). You can supply up to 100
accession numbers.}

\item{reviewed}{Logical: If TRUE, only return
"UniProtKB/Swiss-Prot" (reviewed) entries; If FALSE, only return TrEMBL
(un-reviewed) entries.}

\item{isoform}{Numeric: you have three options:\itemize{
\item 0: Exclude isoforms.
\item 1: Return isoforms only.
\item 2: Return both.}
see: \href{https://www.uniprot.org/help/alternative_products}{Alternative
products}}

\item{go_term}{Limit the search to entries associated with your supplied GO
(\href{https://www.uniprot.org/help/gene_ontology}{Gene Ontology}) term.
You can supply Either GO ID or a character string -partially or fully-
matching the term. e.g. "GO:0001776" or "leukocyte homeostasis". if You
supply "leukocyte", any term containing that word will be included,
e.g "leukocyte chemotaxis", "leukocyte activation".}

\item{keyword}{Limit the search to entries that contain your supplied
keyword. see: \href{https://www.uniprot.org/keywords/}{UniProt Keywords}}

\item{ec}{\href{https://enzyme.expasy.org/}{EC (Enzyme Commission) number(s)}.
You can supply up to 20 EC numbers.}

\item{gene}{\href{https://www.uniprot.org/help/gene_name}{UniProt gene
name(s)}. You can supply up to 20 gene names. e.g. if you supply
"CD40", "CD40 ligand" will also be included.}

\item{exact_gene}{\href{https://www.uniprot.org/help/gene_name}{UniProt
exact gene name(s)}. You can supply up to 20 exact gene names. e.g.
if you supply "CD40", "CD40 ligand" will not be included in the results.}

\item{protein}{\href{https://www.uniprot.org/help/protein_names}{UniProt
protein name}}

\item{organism}{\href{https://www.uniprot.org/taxonomy/}{Organism name}.}

\item{taxid}{NIH-NCBI \href{https://www.uniprot.org/taxonomy/}{Taxon ID}.
You can supply up to 20 taxon IDs.}

\item{pubmed}{Entries which \href{https://www.uniprot.org/citations/}{cite
to} the article with your supplied PubMed ID.}

\item{seq_length}{An exact sequence length (e.g. 150) or a range of sequence
lengths (e.g. "130-158").}

\item{md5}{Sequence md5 value.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A List where each element corresponds to one UniProt entity returned
  by your search query. The element itself is a sub-list containing all
  information that UniProt has about that entity.
}
\description{
Using this function, you can search and retrieve UniProt Knowledge-base
  (UniProtKB) protein entries using variety of options. You may also
  refine your search with modifiers such as sequence length, review status
  etc. See "Arguments" section" for more information.
}
\details{
Note that this is a search function. Thus, you are not required to fill
  every argument; You may use whatever combinations of arguments you see
  fit for your query.s
  \cr UniProt Entries are grouped in two sections:\enumerate{
  \item Reviewed(Swiss-Prot): Manually annotated records with information
  extracted from literature and curator-evaluated computational analysis.
  \item Unreviewed (TrEMBL): Computationally analyzed records that await
  full manual annotation.}
}
\section{Corresponding API Resources}{

 "GET https://www.ebi.ac.uk/proteins/api/proteins"
}

\examples{
\donttest{
rba_uniprot_proteins_search(accession = "Q99616")
}
\donttest{
rba_uniprot_proteins_search(gene = "cd40")
}
\donttest{
rba_uniprot_proteins_search(gene = "cd40 ligand")
}
\donttest{
rba_uniprot_proteins_search(gene = "cd40",  reviewed = TRUE)
}
\donttest{
rba_uniprot_proteins_search(gene = "cd40",  reviewed = TRUE, isoform = 1)
}
\donttest{
rba_uniprot_proteins_search(keyword = "Inhibition of host chemokines by virus")
}
\donttest{
rba_uniprot_proteins_search(keyword = "chemokines")
}

}
\references{
\itemize{
  \item The UniProt Consortium, UniProt: the universal protein
  knowledgebase in 2021, Nucleic Acids Research, Volume 49, Issue D1,
  8 January 2021, Pages D480–D489, https://doi.org/10.1093/nar/gkaa1100
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Proteins": 
\code{\link{rba_uniprot_proteins}()},
\code{\link{rba_uniprot_proteins_crossref}()}
}
\concept{"UniProt - Proteins"}
