% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_proteomes.R
\name{rba_uniprot_genecentric_search}
\alias{rba_uniprot_genecentric_search}
\title{Search Gene-Centric Proteins}
\usage{
rba_uniprot_genecentric_search(upid = NULL, accession = NULL, gene = NULL, ...)
}
\arguments{
\item{upid}{\href{https://www.uniprot.org/help/proteome_id}{UniProt Proteome
identifier (UPID)}. You can supply up to 100 UPIDs.}

\item{accession}{\href{https://www.uniprot.org/help/accession_numbers}{
UniProtKB primary or secondary accession}(s). You can supply up to 100
accession numbers.}

\item{gene}{unique gene identifier(s) found in MOD,
\href{https://www.ensembl.org/info/genome/genebuild/gene_names.html}{Ensembl},
Ensembl Genomes, \href{https://www.uniprot.org/help/gene_name}{OLN},
\href{https://www.uniprot.org/help/gene_name}{ORF} or
\href{https://www.uniprot.org/help/gene_name}{UniProt Gene Name}.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
a list containing gene-centric proteins search hits.
}
\description{
Using this function you can search UniProt for available gene-centrics from
  proteomes. For more information,
  see \href{https://www.uniprot.org/help/proteome}{What are proteomes?} and
  \href{https://www.uniprot.org/help/gene_centric_isoform_mapping}{Automatic
  gene-centric isoform mapping for eukaryotic reference proteome entries.}
  You may also refine your search with modifiers upid, accession and gene.
  See "Arguments section" for more information.
}
\details{
Note that this is a search function. Thus, you are not required to fill
  every argument; You may use whatever combinations of arguments you see
  fit for your query.
}
\section{Corresponding API Resources}{

 "GET https://ebi.ac.uk/proteins/api/genecentric"
}

\examples{
\donttest{
rba_uniprot_genecentric_search(accession = "P59594")
}
\donttest{
rba_uniprot_genecentric_search(gene = "Spike")
}
\donttest{
rba_uniprot_genecentric_search(upid = "UP000000354")
}

}
\references{
\itemize{
  \item The UniProt Consortium, UniProt: the universal protein
  knowledgebase in 2021, Nucleic Acids Research, Volume 49, Issue D1,
  8 January 2021, Pages D480–D489, https://doi.org/10.1093/nar/gkaa1100
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Proteomes": 
\code{\link{rba_uniprot_genecentric}()},
\code{\link{rba_uniprot_proteomes_search}()},
\code{\link{rba_uniprot_proteomes}()}
}
\concept{"UniProt - Proteomes"}
