% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_exporter_reaction}
\alias{rba_reactome_exporter_reaction}
\title{Get a Reactome Reaction Event}
\usage{
rba_reactome_exporter_reaction(
  event_id,
  save_to = NA,
  output_format = "png",
  resource = "TOTAL",
  diagram_profile = "Modern",
  analysis_profile = "Standard",
  token = NA,
  exp_column = NA,
  image_quality = 5,
  flag_element = NA,
  flg_interactors = TRUE,
  sel = NA,
  title = TRUE,
  margin = 15,
  ...
)
}
\arguments{
\item{event_id}{Reactome
\href{https://reactome.org/content/schema/ReactionLikeEvent}{Reaction-like
event}'s identifier.}

\item{save_to}{NA or Character:\itemize{
\item NA: Save the file to an automatically-generated path.
\item Character string: A valid file path to save the file to.}}

\item{output_format}{Images format, Can be one of: png (default), jpeg,
svg or gif.}

\item{resource}{The analysis resource for which the results will be
overlaid on top of the given pathways overview.}

\item{diagram_profile}{Color profile of diagrams, should be one of "Copper"
(default), "Copper Plus", "Barium Lithium" or "calcium salts".}

\item{analysis_profile}{Color profile of analysis, should be one of:
"Standard" (default), "Strosobar" or "Copper Plus".}

\item{token}{The analysis Token for which the results will be overlaid on
top of the given pathways overview. see:
\code{\link{rba_reactome_analysis}}.}

\item{exp_column}{numeric: (only if token is provided) Specify the
expression column for the overlay.}

\item{image_quality}{Numeric: A number  ranging from 1 to 10. 1 is the
lowest quality and 10 is the highest (default = 5).}

\item{flag_element}{Gene name, protein ID, chemical ID or Reactome ID of a
diagram's element to be flagged.}

\item{flg_interactors}{Logical: Should the interactor be considered when
flagging a diagram element? (default = TRUE)}

\item{sel}{CSV line for highlighting element(s) selection in the diagram.}

\item{title}{Logical: Should the pathway name be displayed below the image?
(default = TRUE)}

\item{margin}{Numeric: A number ranging from 0 to 20 to set as the image's
margin. (default = 15)}

\item{...}{rbioapi option(s). Refer to \code{\link{rba_options}}'s
arguments documentation for more information on available options.}
}
\value{
NULL, Based to the inputs, an image file will be saved to disk.
}
\description{
This function will Save a Reactome event of class "ReactionLikeEvent" as
  an image file.
}
\details{
Note that this function will save Reaction-like event separately and out
  of it's parent pathway context. To overlay a Reaction on it's parent
  pathway, use \code{\link{rba_reactome_exporter_diagram}}.
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService//exporter/reaction/
 {identifier}.{ext}"
}

\examples{
\dontrun{
rba_reactome_exporter_diagram(event_id = "R-HSA-6787403",
    create_document = FALSE)
}
\dontrun{
rba_reactome_exporter_diagram(event_id = "R-HSA-6787403",
     output_format = "svg",
     save_to = "reactome_reacion_image.svg")
}

}
\references{
\itemize{
  \item Jassal B, Matthews L, Viteri G, Gong C, Lorente P, Fabregat A,
  Sidiropoulos K, Cook J, Gillespie M, Haw R, Loney F, May B, Milacic M,
  Rothfels K, Sevilla C, Shamovsky V, Shorser S, Varusai T, Weiser J, Wu G,
  Stein L, Hermjakob H, D'Eustachio P. The reactome pathway knowledgebase.
  Nucleic Acids Res. 2020 Jan 8;48(D1):D498-D503. doi: 10.1093/nar/gkz1031.
  PubMed PMID: 31691815.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  }
}
\seealso{
\code{\link{rba_reactome_exporter_diagram}}
\code{\link{rba_reactome_analysis}}

Other "Reactome Content Service - Format Exporter": 
\code{\link{rba_reactome_exporter_diagram}()},
\code{\link{rba_reactome_exporter_event}()},
\code{\link{rba_reactome_exporter_overview}()}
}
\concept{"Reactome Content Service - Format Exporter"}
