% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BlockchainRpcs.R
\name{verifytxoutproof}
\alias{verifytxoutproof}
\title{RPC-JSON API: verifytxoutproof}
\usage{
verifytxoutproof(con, proof)
}
\arguments{
\item{con}{object of class \code{CONRPC}.}

\item{proof}{\code{character} the hex-encoded proof generated
by gettxoutproof.}
}
\value{
A S4-object of class \code{ANSRPC}.
}
\description{
Verifies that a proof points to a transaction in a block,
returning the transaction it commits to and throwing an
RPC error if the block is not in our best chain.
}
\references{
\url{https://bitcoin.org/en/developer-reference#verifytxoutproof},
\url{https://bitcoin.org/en/developer-reference#remote-procedure-calls-rpcs}
}
\seealso{
Other Blockchain RPCs: 
\code{\link{decodescript}()},
\code{\link{getbestblockhash}()},
\code{\link{getblockchaininfo}()},
\code{\link{getblockcount}()},
\code{\link{getblockhash}()},
\code{\link{getblockheader}()},
\code{\link{getblock}()},
\code{\link{getchaintips}()},
\code{\link{getchaintxstats}()},
\code{\link{getdifficulty}()},
\code{\link{getmempoolancestors}()},
\code{\link{getmempooldescendants}()},
\code{\link{getmempoolentry}()},
\code{\link{getmempoolinfo}()},
\code{\link{getrawmempool}()},
\code{\link{gettxoutproof}()},
\code{\link{gettxoutsetinfo}()},
\code{\link{gettxout}()},
\code{\link{pruneblockchain}()},
\code{\link{verifychain}()}
}
\author{
Bernhard Pfaff
}
\concept{Blockchain RPCs}
