% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{agemodel.it}
\alias{agemodel.it}
\title{Extract one age-model iteration}
\usage{
agemodel.it(it, set = get("info"), BCAD = set$BCAD, save.info = FALSE)
}
\arguments{
\item{it}{The MCMC iteration of which the age-model should be calculated.}

\item{set}{Detailed information of the current run, stored within this session's memory as variable info.}

\item{BCAD}{The calendar scale of graphs and age output-files is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{save.info}{If TRUE, a variable called `info' with relevant information about the run (e.g., core name, priors, settings, ages, output) is saved into the working directory. Note that this will overwrite any existing variable with the same name.}
}
\value{
A variable with two columns - depth and the age-depth model of a single iteration.
}
\description{
For one MCMC iteration (it), extract the corresponding age-depth model.
}
\examples{
\dontrun{
  Bacon(run=FALSE, coredir=tempfile())
  agedepth(age.res=50, d.res=50, d.by=10)
  lines(agemodel.it(5), col="red")
}
}
\author{
Maarten Blaauw, J. Andres Christen
}
