% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketdata.R
\name{read_marketdata}
\alias{read_marketdata}
\title{Read and parses files delivered by B3}
\usage{
read_marketdata(
  filename,
  template = NULL,
  parse_fields = TRUE,
  do_cache = TRUE
)
}
\arguments{
\item{filename}{a string containing a path for the file.}

\item{template}{a string with the template name.}

\item{parse_fields}{a logical indicating if the fields must be parsed.}

\item{do_cache}{Whether to use cache or not (default = TRUE)

Each \code{template} has a default value for the \code{filename}, if the given
file name equals one template filename attribute, the matched template
is used to parse the file.
Otherwise the template must be provided.

The function \code{show_templates} can be used to view the available templates
and their default filenames.}
}
\value{
\code{data.frame} of a list of \code{data.frame} containing data parsed from
files.
}
\description{
B3, and previously BMF&Bovespa, used to deliver many files with a diverse
set of valuable data and informations that can be used to study of can
be called of marketdata.
There are files with informations about futures, option, interest
rates, currency rates, bonds and many other subjects.
}
\examples{
\dontrun{
# Eletro.txt matches the filename of Eletro template
path <- "Eletro.txt"
df <- read_marketdata(path)
path <- "Indic.txt"
df <- read_marketdata(path, template = "Indic")
path <- "PUWEB.TXT"
df <- read_marketdata(path, template = "PUWEB")
}
}
\seealso{
show_templates display_template
}
