% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_overlay.R
\name{add_overlay}
\alias{add_overlay}
\title{Add Overlay}
\usage{
add_overlay(
  hillshade,
  overlay,
  alphacolor = NULL,
  alphalayer = 1,
  alphamethod = "max",
  gamma_correction = TRUE
)
}
\arguments{
\item{hillshade}{A three-dimensional RGB array or 2D matrix of shadow intensities.}

\item{overlay}{A three or four dimensional RGB array, where the 4th dimension represents the alpha (transparency) channel. 
If the array is 3D, `alphacolor` should also be passed to indicate transparent regions.}

\item{alphacolor}{Default `NULL`. If `overlay` is a 3-layer array, this argument tells which color is interpretted as completely transparent.}

\item{alphalayer}{Default `1`. Defines minimum tranparaency of layer. If transparency already exists in `overlay`, the way `add_overlay` combines 
the two is determined in argument `alphamethod`.}

\item{alphamethod}{Default `max`. Method for dealing with pre-existing transparency with `layeralpha`. 
If `max`, converts all alpha levels higher than `layeralpha` to the value set in `layeralpha`.
If `multiply`, multiples all pre-existing alpha values with `layeralpha`.
If `none`, keeps existing tranparencies and only changes opaque entries.}

\item{gamma_correction}{Default `TRUE`. Controls gamma correction when adding colors. Default exponent of 2.2.}
}
\value{
Hillshade with overlay.
}
\description{
Overlays an image (with a transparency layer) on the current map.
}
\examples{
#Here, we overlay a base R elevation plot with our raytraced shadow layer:

fliplr = function(x) {
 x[,ncol(x):1]
}
\dontrun{
tempfilename = tempfile()
old.par = par(no.readonly = TRUE)
on.exit(par(old.par))
png(tempfilename,width = 401,height=401)
par(mar = c(0,0,0,0))
raster::image(fliplr(montereybay),axes = FALSE,col = rev(terrain.colors(1000)))
dev.off()
tempmap = png::readPNG(tempfilename)
}

\dontrun{
montereybay \%>\%
  ray_shade(zscale=50,maxsearch = 500,anglebreaks = seq(20,30,0.1)) \%>\%
  add_overlay(tempmap,alphalayer = 0.5) \%>\%
  plot_map()
}

#Combining base R plotting with rayshader's spherical color mapping and raytracing:
\dontrun{
montereybay \%>\%
  sphere_shade() \%>\%
  add_overlay(tempmap,alphalayer = 0.4) \%>\%
  add_shadow(ray_shade(montereybay,zscale=50,maxsearch = 500)) \%>\%
  plot_map()
}
}
