% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_cornell.R
\name{generate_cornell}
\alias{generate_cornell}
\title{Generate Cornell Box}
\usage{
generate_cornell(
  light = TRUE,
  lightintensity = 5,
  lightcolor = "white",
  lightwidth = 332,
  lightdepth = 343,
  leftcolor = "#1f7326",
  rightcolor = "#a60d0d",
  roomcolor = "#bababa"
)
}
\arguments{
\item{light}{Default `TRUE`. Whether to include a light on the ceiling of the box.}

\item{lightintensity}{Default `5`. The intensity of the light.}

\item{lightcolor}{Default `white`. The color the of the light.}

\item{lightwidth}{Default `332`. Width (z) of the light.}

\item{lightdepth}{Default `343`. Depth (x) of the light.}

\item{leftcolor}{Default `#1f7326` (green).}

\item{rightcolor}{Default `#a60d0d` (red).}

\item{roomcolor}{Default `#bababa` (light grey).}
}
\value{
Tibble containing the scene description of the Cornell box.
}
\description{
Generate Cornell Box
}
\examples{
#Generate and render the default Cornell box.
scene = generate_cornell()
\donttest{
render_scene(scene, samples=200,aperture=0, fov=40, ambient_light=FALSE, parallel=TRUE)
}

#Make a much smaller light in the center of the room.
scene = generate_cornell(lightwidth=200,lightdepth=200)
\donttest{
render_scene(scene, samples=200,aperture=0, fov=40, ambient_light=FALSE, parallel=TRUE)
}

#Place a sphere in the middle of the box.
scene = scene \%>\%
  add_object(sphere(x=555/2,y=555/2,z=555/2,radius=555/4))
\donttest{
render_scene(scene, samples=200,aperture=0, fov=40, ambient_light=FALSE, parallel=TRUE)
}

#Reduce "fireflies" by setting a clamp_value in render_scene()
\donttest{
render_scene(scene, samples=200,aperture=0, fov=40, ambient_light=FALSE, 
             parallel=TRUE,clamp_value=3)
}
# Change the color scheme of the cornell box
\donttest{
new_cornell = generate_cornell(leftcolor="purple", rightcolor="yellow")
render_scene(new_cornell, samples=200,aperture=0, fov=40, ambient_light=FALSE, 
             parallel=TRUE,clamp_value=3)
}
}
