% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawr_to_clip.R
\name{rawr_to_clip}
\alias{rawr_to_clip}
\title{Retrieve raw R code from any github, kaggle, stack overflow, blogdown, or data camp web page}
\usage{
rawr_to_clip(url, method, padding)
}
\arguments{
\item{url}{Link to an R file on supported website (github, kaggle, datacamp, tidytext)}

\item{method}{Not all websites are formatted consistently. To overcome this, rawr may have
more than one method for any site. If what rawr returns is not sensible, try setting method
parameter to integers 2 and greater to try other available methods}

\item{padding}{Specify what goes between the last character of one code block and the
first character of the next code block. Default is a two new lines, which appears
visually as one new line between code blocks.}
}
\value{
The raw R code from the URL provided written to the system clipboard (and so can be
    pasted in the usual way with ctrl + v / cmd + v). No object is returned to the R interpreter.
}
\description{
Retrieve raw R code from any github, kaggle, stack overflow, blogdown, or data camp web page
}
\examples{
\donttest{

library(dplyr)
rawr_to_clip("https://cran.r-project.org/web/packages/tidytext/vignettes/tidytext.html")

# Also works with the magrittr pipe
"https://github.com/hadley/vis-eda/blob/master/travel.R" \%>\% rawr_to_clip
}

}
