% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-utils.R
\name{ravedash_footer}
\alias{ravedash_footer}
\title{A hovering footer at bottom-right}
\usage{
ravedash_footer(
  module_id = NULL,
  label = "Run Analysis",
  auto_recalculation = TRUE,
  class = NULL,
  style = NULL
)
}
\arguments{
\item{module_id}{'RAVE' module ID}

\item{label}{run-analysis button label; default is \code{"Run Analysis"}}

\item{auto_recalculation}{whether to show the automatic calculation button;
default is true}

\item{class}{additional class for the footer}

\item{style}{additional style for the footer}
}
\value{
'HTML' tags
}
\description{
Internally used. Do not call explicitly
}
\examples{

library(shiny)
# dummy variables for the example
data_loaded <- TRUE

# UI code
ravedash_footer("my_module")

# server code to set message
server <- function(input, output, session){

  module_server_common(input, output, session, function(){

    # check if data has been loaded
    if(data_loaded) {

      # if yes, then set the footer message
      fire_rave_event("loader_message",
                      "my_project/subject - Epoch: Auditory")
      return(TRUE)
    } else {

      # No data found, unset the footer message
      fire_rave_event("loader_message", NULL)
      return(FALSE)
    }

  })
}

}
