% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Renyi.R
\name{Renyi}
\alias{Renyi}
\title{Renyi Diversity Index Calculation}
\usage{
Renyi(
  x,
  window = 3,
  alpha = 1,
  base = exp(1),
  rasterOut = TRUE,
  np = 1,
  na.tolerance = 1,
  cluster.type = "SOCK",
  debugging = FALSE
)
}
\arguments{
\item{x}{A raster object which can be a matrix, SpatialGridDataFrame, SpatRaster, list, or RasterStack.}

\item{window}{The size of the moving window; must be an odd integer.}

\item{alpha}{A numeric vector of alpha values for the Renyi index.}

\item{base}{The logarithm base for the calculation, default is natural logarithm.}

\item{rasterOut}{Logical; if TRUE, returns a SpatRaster object, otherwise returns a list.}

\item{np}{Number of processes for parallel computation.}

\item{na.tolerance}{Tolerance level for NA values, must be within [0-1].}

\item{cluster.type}{Type of cluster for parallel computation, either "SOCK" or "MPI".}

\item{debugging}{Logical; if TRUE, provides additional console output for debugging.}
}
\value{
A SpatRaster object or a list of calculated Renyi indices.
}
\description{
Computes Renyi diversity index for a given raster object. This function allows
specifying window size, alpha values, and various other parameters for 
the calculation of the Renyi index.
}
\examples{
\dontrun{
result <- Renyi(ndvi.8bit, window = 3, alpha = c(0, 1, 2))
}

}
