% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/world.R
\docType{data}
\name{world}
\alias{world}
\title{Natural Earth world dataset}
\format{
A \code{SpatVector} containing the following columns:
\describe{
  \item{world}{SpatVector of the world dissolved on continents. Details about columns should be listed here if applicable.}
}
}
\source{
\url{https://www.naturalearthdata.com/}
}
\usage{
load_world()
}
\description{
A \code{SpatVector} (EPSG: 4326) of the continents.
}
\details{
This dataset represents the world, with spatial information dissolved on continents.
It is stored as a \code{SpatVector}, suitable for various spatial operations and mapping.
}
\examples{
world <- readRDS(system.file("extdata", "world.rds", package = "rasterdiv"))
}
\references{
\url{https://www.naturalearthdata.com/}
}
\keyword{datasets}
