# raster package
# Authors: Robert J. Hijmans,  r.hijmans@gmail.com
# Date : October 2008
# Version 0.9
# Licence GPL v3


if (!isGeneric("expand")) {
	setGeneric("expand", function(x, y, ...)
		standardGeneric("expand"))
}	

setMethod('expand', signature(x='Raster', y='ANY'), 
function(x, y, filename='', value=NA, ...) {

	test <- try ( y <- extent(y), silent=TRUE )
	if (class(test) == "try-error") {
		stop('Cannot get an Extent object from argument y')
	}

	filename <- trim(filename)
	
	bndbox <- extent(y)
	res <- res(x)
# snap points to pixel boundaries
	xmn <- round(xmin(bndbox) / res[1]) * res[1]
	xmx <- round(xmax(bndbox) / res[1]) * res[1]
	ymn <- round(ymin(bndbox) / res[2]) * res[2]
	ymx <- round(ymax(bndbox) / res[2]) * res[2]
	
# only expanding here, not cutting
	xmn <- min(xmn, xmin(x))
	xmx <- max(xmx, xmax(x))
	ymn <- min(ymn, ymin(x))
	ymx <- max(ymx, ymax(x))
	
	if (inherits(x, 'RasterLayer')) {
		outRaster <- raster(x)
	} else {
		outRaster <- brick(x, values=FALSE)
	}
	
	bndbox <- extent(xmn, xmx, ymn, ymx)
	outRaster <- setExtent(outRaster, bndbox, keepres=TRUE)

	datatype <- list(...)$datatype
	if (is.null(datatype)) {
		if (inherits(x, 'RasterStack')) {
			datatype <- 'FLT4S'
		} else {
			datatype <- dataType(x)
		}
	} 
	
	if (canProcessInMemory(outRaster, 2)) {
		d <- matrix(nrow=ncell(outRaster), ncol=nlayers(x))
		d[] <- value
		cells <- cellsFromExtent(outRaster, extent(x))
		d[cells, ] <- getValues(x)
		outRaster <- setValues(outRaster, d)	
		if (filename != '') {
			outRaster <- writeRaster(outRaster, filename=filename, datatype=datatype, ...)
		}
	} else { 
		if (filename == '') {
			filename <- rasterTmpFile()						
		}

		startrow <- rowFromY(outRaster, yFromRow(x, 1))
		endrow <- rowFromY(outRaster, yFromRow(x, nrow(x)))
		startcol <- colFromX(outRaster, xFromCol(x, 1))
		endcol <- colFromX(outRaster, xFromCol(x, ncol(x)))
		
		d <- matrix(nrow=ncol(outRaster), ncol=nlayers(x))
		xr <- 0
		outRaster <- writeStart(outRaster, filename=filename, datatype=datatype, ... )
		pb <- pbCreate(nrow(outRaster), type=.progress(...))
		for (r in 1:nrow(outRaster)) {
			d[] <- value
			if (r >= startrow & r <= endrow) {
				xr <- xr + 1
				d[startcol:endcol, ] <- getValues(x, xr)
			}
			outRaster <- writeValues(outRaster, d, r)
			pbStep(pb, r) 			
		}
		pbClose(pb)
		outRaster <- writeStop(outRaster)
	} 
	return(outRaster)
}
)


