% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DemandPoints.R
\name{make.DemandPoints}
\alias{make.DemandPoints}
\title{Generate demand points for RAP}
\usage{
make.DemandPoints(points, n = 100L, quantile = 0.5,
  kernel.method = c("ks", "hypervolume")[1], ...)
}
\arguments{
\item{points}{\code{\link[base]{matrix}} object containing points.}

\item{n}{\code{integer} number of demand points to use for each attribute space for each species. Defaults to \code{100L}.}

\item{quantile}{\code{numeric} quantile to generate demand points within. If 0 then demand points are generated across the full range of values the \code{points} intersect. Defaults to \code{0.5}.}

\item{kernel.method}{\code{character} name of kernel method to use to generate demand points. Defaults to \code{'ks'}.}

\item{...}{arguments passed to kernel density estimating functions}
}
\value{
\code{\link{DemandPoints}} object.
}
\description{
This function generates demand points to characterize a distribution of points.
}
\details{
Broadly speaking, demand points are generated by fitting a kernal to the input \code{points}. A shape is then fit to the extent of 
the kernal, and then points are randomly generated inside the shape. The demand points are generated as random points inside the shape. The weights 
for each demand point are calculated the estimated density of input points at the demand point. By supplying 'ks' as an argument to \code{method} in 
\code{kernel.method}, the shape is defined using a minimum convex polygon \code{\link[adehabitatHR]{mcp}} and 
\code{\link[ks]{kde}} is used to fit the kernel. Note this can only be used when the data is low-dimensional (d < 3). By supplying
'hypervolume' as an argument to \code{method}, the \code{\link[hypervolume]{hypervolume}} function is used to create the demand points.
This method can be used for hyper-dimensional data (d << 3).
}
\examples{
data(cs_spp, cs_space)
# generate species points
species.points <- randomPoints(cs_spp[[1]], n=100, prob=TRUE)
env.points <- extract(cs_space, species.points)
# generate demand points for a 1d space using ks
dps1 <- make.DemandPoints(
points=env.points[,1],
kernel.method='ks'
)
# generate demand points for a 2d space using hypervolume
dps2 <- make.DemandPoints(
points=env.points,
kernel.method='hypervolume',
samples.per.point=10
)
}
\seealso{
\code{\link[hypervolume]{hypervolume}}, \code{\link[ks]{kde}}, \code{\link[adehabitatHR]{mcp}}.
}
