% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{keep_simulations}
\alias{keep_simulations}
\title{Keep simulations for a factorial experiment}
\usage{
keep_simulations(l, s)
}
\arguments{
\item{l}{A list from read_apsim with Factorial.Permutation as root.}

\item{s}{a list with factor as name and levels as value to keep.
The factor is kept if it is not specified.}
}
\value{
A new list with removed simulations.
}
\description{
Keep simulations for a factorial experiment
}
\examples{
wheat <- read_apsimx(system.file("wheat.apsimx", package = "rapsimng"))
permutation <- search_path(wheat, path = "[Factors].Permutation")
permutation_new <- keep_simulations(permutation$node, list(V = "2"))
get_simulations(permutation_new)

permutation_new <- keep_simulations(permutation$node, list(Cv = c("Axe", "Bolac")))
get_simulations(permutation_new)

permutation_new <- keep_simulations(permutation$node,
                                    list(V = "1", Cv = c("Axe", "Bolac")))
get_simulations(permutation_new)
}
