% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MapCanvas-methods.R
\name{canvas.save}
\alias{canvas.fetch}
\alias{canvas.save}
\title{Project's canvas}
\usage{
canvas.save(con)

canvas.fetch(con)
}
\arguments{
\item{con}{An sqlite connection pointing to a valid \code{rangeMapper}
project.}
}
\value{
\code{canvas.fetch} Returns a
           \code{\link[sp]{SpatialPixelsDataFrame}} object.
}
\description{
The canvas is a regular grid of a given resolution. Each range map is
overlayed onto the canvas and the results saved to project.
}
\note{
The method canvasSave() fails if \code{grid.size} was not set and if
           the canvas was already constructed for the given project.
}
\examples{
wd = tempdir()
dbcon = rangeMap.start(file = "test.sqlite", overwrite = TRUE, dir = wd)
global.bbox.save(con = dbcon)
gridSize.save(dbcon, gridSize = 2)
canvas.save(dbcon)
cnv = canvas.fetch(dbcon)
summary(cnv)
plot(cnv, col = 'grey', axes = TRUE)

}
\seealso{
\code{\link{rangeMap.save}}.\cr \code{\link{gridSize.save}}
}

