% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_plan.R
\name{check_plan}
\alias{check_plan}
\alias{print.checkplan}
\title{Check randomisation plan}
\usage{
check_plan(
  n_rando,
  n_strata,
  arms = c("A", "B"),
  blocksizes = c(1, 2),
  n_sim = 1000
)

\method{print}{checkplan}(x, ...)
}
\arguments{
\item{n_rando}{number of participants to randomise}

\item{n_strata}{number of strata}

\item{arms}{arms that will be randomised}

\item{blocksizes}{number of each randomisation group per block (e.g. 1 = one of each arm per block,
2 = per of each arm per block)}

\item{n_sim}{number of simulations}

\item{x}{check_plan object}

\item{...}{options passed to print.data.frame}
}
\value{
list of class checkplan with slots the same slots as input to the
function plus mean (mean imbalance), counts (counts of the imbalances) and
worst_case (randomisation results with the worst observed imbalance)
}
\description{
Before committing to a randomisation plan (in terms of the number of strata,
block sizes etc) it can be useful to estimate the imbalance that might be
expected. This function simulates trials of a given sample size and returns
the imbalance that might be expected.
}
\section{Functions}{
\itemize{
\item \code{print(checkplan)}: Print method for check_plan output

}}
\examples{

check_plan(50, 3, n_sim = 50)

}
\seealso{
https://www.sealedenvelope.com/randomisation/simulation/
}
