% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/randomizr.r
\name{complete_ra}
\alias{complete_ra}
\title{Complete Random Assignment}
\usage{
complete_ra(N, m = NULL, num_arms = NULL, m_each = NULL,
  condition_names = NULL)
}
\arguments{
\item{N}{the total number of units in the experimental sample.}

\item{m}{if specified, a two-group design is assumed.  m is the total number of units to be assigned to treatment. Should only be specified for a two group design in which exactly m of N units to treatment. If not specified, half of the sample (N/2) will be assigned to treatment. Is null by default.}

\item{num_arms}{the total number of treatment arms. If unspecified, will be determined from the length of m_each or condition_names.}

\item{m_each}{a numeric vector giving the size of each treatment group. Must sum to N. If unspecified, equally sized (rounded) groups will be assumed.}

\item{condition_names}{a character vector giving the names of the treatment groups.  If unspecified, the treatment groups will be names T1, T2, T3, etc.}
}
\description{
This function conducts complete random assignment, a procedure in which a pre-specified number of units is assigned to each treatment condition.  This function can accomodate any number of treatment arms.
}
\examples{
# Two Group Designs

Z <- complete_ra(N=100)
table(Z)

Z <- complete_ra(N=100, m=50)
table(Z)

Z <- complete_ra(N=100, m_each = c(30, 70),
                 condition_names = c("control", "treatment"))
table(Z)

# Multi-arm Designs
Z <- complete_ra(N=100, num_arms=3)
table(Z)

Z <- complete_ra(N=100, m_each=c(30, 30, 40))
table(Z)

Z <- complete_ra(N=100, m_each=c(30, 30, 40),
                 condition_names=c("control", "placebo", "treatment"))
table(Z)

Z <- complete_ra(N=100, condition_names=c("control", "placebo", "treatment"))
table(Z)
}
\keyword{assignment}
\keyword{random}

