% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corGuess.R
\name{corGuess}
\alias{corGuess}
\title{Representing the expected number of correct guesses}
\usage{
corGuess(type)
}
\arguments{
\item{type}{character string, should be one of \code{"CS"} or \code{"DS"},
see Details.}
}
\value{
\code{S4} object of class \code{corGuess}, a formal representation of the
issue of correct guesses in a clinical trial.
}
\description{
Represents the expected number of correct guesses of randomization sequences.
}
\details{
Selection bias can be an issue in the design of a clinical trial. The 
expected number of correct guesses is one measure for selection bias.
The \code{corGuess} function is a constructor function
for an S4 object of the class \code{corGuess} representing the issue of
correct guesses in a clinical trial. The parameter \code{type} takes the 
following values:
\describe{
  \item{\code{"CS"}}{refers to "convergence strategy", i.e. the investigator
  predicts the treatment which has hitherto occured less often.}
  \item{\code{"DS"}}{refers to "divergence strategy", i.e. the investigator
  predicts the treatment which has hitherto occured more often.}
}
}
\references{
D. Blackwell and J.L. Hodges Jr. (1957) Design for the control of 
selection bias. \emph{Annals of Mathematical Statistics}, \strong{25}, 449-60.
}
\seealso{
Other issues: \code{\link{chronBias}},
  \code{\link{combineBias}}, \code{\link{imbal}},
  \code{\link{issue}}, \code{\link{selBias}},
  \code{\link{setPower}}
}
