% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsdPar.R
\name{bsdPar}
\alias{bsdPar}
\title{Representing Big Stick Design}
\usage{
bsdPar(N, mti, groups = LETTERS[1:2])
}
\arguments{
\item{N}{integer for the total sample size of the trial.}

\item{mti}{maximum tolerated imbalance in patient numbers during the trial.}

\item{groups}{character vector of labels for the different treatments.}
}
\value{
\code{S4} object of the class \code{bsdPar}.
}
\description{
Represents the randomization procedure Big Stick Design.
}
\details{
Tossing a fair coin as long as the difference in group sizes doesn`t
exceed the \code{mti}. If the \code{mti} is reached a deterministic
allocation is done, so that the difference in group sizes is reduced.
}
\references{
J. F. Soares and C. F. Jeff Wu (1983) Some Restricted Randomization Rules in
Sequential Designs. \emph{Comm. in Stat.}, \strong{12}, 2017-34.
}
\seealso{
Other randomization procedures: \code{\link{abcdPar}},
  \code{\link{bbcdPar}}, \code{\link{chenPar}},
  \code{\link{crPar}}, \code{\link{createParam}},
  \code{\link{ebcPar}}, \code{\link{gbcdPar}},
  \code{\link{hadaPar}}, \code{\link{mpPar}},
  \code{\link{pbrPar}}, \code{\link{rarPar}},
  \code{\link{rpbrPar}}, \code{\link{rtbdPar}},
  \code{\link{tbdPar}}, \code{\link{udPar}}
}

