% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomGODB.R
\name{geneListDistHitters}
\alias{geneListDistHitters}
\title{geneListDistHitters}
\usage{
geneListDistHitters(geneList, GOGOA3, ontologies = NULL, verbose = TRUE)
}
\arguments{
\item{geneList}{character vector listg of gene names}

\item{GOGOA3}{return value of minimalistGODB::buildGODatabase()}

\item{ontologies}{character c("biological_process","molecular_function","cellular_component")}

\item{verbose}{Boolean if TRUE print out some information}
}
\value{
returns no value, but has side effect of printing information
}
\description{
compute number of GOGOA3 mappings for genes in geneList
}
\examples{
\dontrun{
# GOGOA3.RData is too large to include in the R package
# so I need to load it from a file that is not in the package.
# Since this is in a file in my own file system, I could not
# include this as a regular example in the package.
# This example is given in full detail in the package vignette.
# You can generate GOGOA3.RData using the package 'minimalistGODB'
# or you can retrieve it from https://github.com/barryzee/GO/databases
dir<-"/Users/barryzeeberg/personal/GODB_RDATA/goa_human/"
load(sprintf("\%s/\%s",dir,"GOGOA3_goa_human.RData"))
geneList<-GOGOA3$ontologies[["biological_process"]][1:10,"HGNC"]
geneListDistHitters(geneList,GOGOA3)
}

}
