/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.variables;

import eu.amidst.core.datastream.Attribute;
import eu.amidst.core.datastream.Attributes;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.DistributionTypeEnum;
import eu.amidst.core.variables.StateSpaceType;
import eu.amidst.core.variables.StateSpaceTypeEnum;
import eu.amidst.core.variables.Variable;
import eu.amidst.core.variables.VariableBuilder;
import eu.amidst.core.variables.stateSpaceTypes.FiniteStateSpace;
import eu.amidst.core.variables.stateSpaceTypes.RealStateSpace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class DynamicVariables
implements Iterable<Variable>,
Serializable {
    private static final long serialVersionUID = -4959625141445606681L;
    public static final String INTERFACE_SUFFIX = "_Interface";
    private List<Variable> nonInterfaceVariables = new ArrayList<Variable>();
    private List<Variable> interfaceVariables = new ArrayList<Variable>();
    private Map<String, Integer> mapping;

    public DynamicVariables() {
        this.mapping = new ConcurrentHashMap<String, Integer>();
    }

    public DynamicVariables(Attributes atts) {
        this.mapping = new ConcurrentHashMap<String, Integer>();
        for (Attribute att : atts.getListOfNonSpecialAttributes()) {
            VariableBuilder builder = new VariableBuilder(att);
            VariableImplementation var = new VariableImplementation(builder, this.nonInterfaceVariables.size());
            if (this.mapping.containsKey(var.getName())) {
                throw new IllegalArgumentException("Attribute list contains duplicated names");
            }
            this.mapping.put(var.getName(), var.getVarID());
            this.nonInterfaceVariables.add(var.getVarID(), var);
            VariableImplementation interfaceVariable = VariableImplementation.newInterfaceVariable(var);
            var.setInterfaceVariable(interfaceVariable);
            this.interfaceVariables.add(var.getVarID(), interfaceVariable);
        }
    }

    public DynamicVariables(Attributes atts, Map<Attribute, DistributionTypeEnum> typeDists) {
        for (Attribute att : atts.getListOfNonSpecialAttributes()) {
            VariableBuilder builder = typeDists.containsKey(att) ? new VariableBuilder(att, typeDists.get(att)) : new VariableBuilder(att);
            VariableImplementation var = new VariableImplementation(builder, this.nonInterfaceVariables.size());
            if (this.mapping.containsKey(var.getName())) {
                throw new IllegalArgumentException("Attribute list contains duplicated names");
            }
            this.mapping.put(var.getName(), var.getVarID());
            this.nonInterfaceVariables.add(var.getVarID(), var);
            VariableImplementation interfaceVariable = VariableImplementation.newInterfaceVariable(var);
            var.setInterfaceVariable(interfaceVariable);
            this.interfaceVariables.add(var.getVarID(), interfaceVariable);
        }
    }

    public void setAttributes(Attributes attributes) {
        VariableImplementation variableImplementation;
        for (Variable variable : this.nonInterfaceVariables) {
            variableImplementation = (VariableImplementation)variable;
            variableImplementation.setAttribute(attributes.getAttributeByName(variable.getName()));
        }
        for (Variable variable : this.interfaceVariables) {
            variableImplementation = (VariableImplementation)variable;
            variableImplementation.setAttribute(attributes.getAttributeByName(this.getVariableFromInterface(variable).getName()));
        }
    }

    public Variable getInterfaceVariable(Variable var) {
        return this.interfaceVariables.get(var.getVarID());
    }

    public Variable getVariableFromInterface(Variable var) {
        return this.nonInterfaceVariables.get(var.getVarID() - this.getNumberOfVars());
    }

    public Variable newMultinomialLogisticDynamicVariable(String name, int nOfStates) {
        return this.newDynamicVariable(name, DistributionTypeEnum.MULTINOMIAL_LOGISTIC, new FiniteStateSpace(nOfStates));
    }

    public Variable newMultinomialLogisticDynamicVariable(String name, List<String> states) {
        return this.newDynamicVariable(name, DistributionTypeEnum.MULTINOMIAL_LOGISTIC, new FiniteStateSpace(states));
    }

    public Variable newMultinomialDynamicVariable(String name, int nOfStates) {
        return this.newDynamicVariable(name, DistributionTypeEnum.MULTINOMIAL, new FiniteStateSpace(nOfStates));
    }

    public Variable newMultinomialDynamicVariable(String name, List<String> states) {
        return this.newDynamicVariable(name, DistributionTypeEnum.MULTINOMIAL, new FiniteStateSpace(states));
    }

    public Variable newGaussianDynamicVariable(Attribute att) {
        return this.newDynamicVariable(att, DistributionTypeEnum.NORMAL);
    }

    public Variable newGaussianDynamicVariable(String name) {
        return this.newDynamicVariable(name, DistributionTypeEnum.NORMAL, new RealStateSpace());
    }

    public Variable newDynamicVariable(Attribute att) {
        VariableImplementation var = new VariableImplementation(new VariableBuilder(att), this.nonInterfaceVariables.size());
        if (this.mapping.containsKey(var.getName())) {
            throw new IllegalArgumentException("Attribute list contains duplicated names");
        }
        this.mapping.put(var.getName(), var.getVarID());
        this.nonInterfaceVariables.add(var);
        VariableImplementation interfaceVariable = VariableImplementation.newInterfaceVariable(var);
        var.setInterfaceVariable(interfaceVariable);
        this.interfaceVariables.add(var.getVarID(), interfaceVariable);
        return var;
    }

    public Variable newDynamicVariable(String name, DistributionTypeEnum distributionTypeEnum, StateSpaceType stateSpaceType) {
        VariableBuilder variableBuilder = new VariableBuilder();
        variableBuilder.setName(name);
        variableBuilder.setDistributionType(distributionTypeEnum);
        variableBuilder.setStateSpaceType(stateSpaceType);
        variableBuilder.setObservable(false);
        VariableImplementation var = new VariableImplementation(variableBuilder, this.nonInterfaceVariables.size());
        if (this.mapping.containsKey(var.getName())) {
            throw new IllegalArgumentException("Attribute list contains duplicated names");
        }
        this.mapping.put(var.getName(), var.getVarID());
        this.nonInterfaceVariables.add(var);
        VariableImplementation interfaceVariable = VariableImplementation.newInterfaceVariable(var);
        var.setInterfaceVariable(interfaceVariable);
        this.interfaceVariables.add(var.getVarID(), interfaceVariable);
        return var;
    }

    public Variable newDynamicVariable(Attribute att, DistributionTypeEnum distributionTypeEnum) {
        VariableBuilder variableBuilder = new VariableBuilder(att);
        variableBuilder.setDistributionType(distributionTypeEnum);
        VariableImplementation var = new VariableImplementation(variableBuilder, this.nonInterfaceVariables.size());
        if (this.mapping.containsKey(var.getName())) {
            throw new IllegalArgumentException("Attribute list contains duplicated names");
        }
        this.mapping.put(var.getName(), var.getVarID());
        this.nonInterfaceVariables.add(var);
        VariableImplementation interfaceVariable = VariableImplementation.newInterfaceVariable(var);
        var.setInterfaceVariable(interfaceVariable);
        this.interfaceVariables.add(var.getVarID(), interfaceVariable);
        return var;
    }

    public Variable newRealDynamicVariable(Variable var) {
        if (!var.isObservable()) {
            throw new IllegalArgumentException("A Real variable should be created from an observed variable");
        }
        if (((StateSpaceType)var.getStateSpaceType()).getStateSpaceTypeEnum() != StateSpaceTypeEnum.REAL) {
            throw new IllegalArgumentException("An Real variable should be created from a real variable");
        }
        VariableBuilder builder = new VariableBuilder(var.getAttribute());
        builder.setName(var.getName() + "_Real");
        VariableImplementation varNew = new VariableImplementation(builder, this.nonInterfaceVariables.size());
        if (this.mapping.containsKey(varNew.getName())) {
            throw new IllegalArgumentException("Attribute list contains duplicated names");
        }
        this.mapping.put(varNew.getName(), varNew.getVarID());
        this.nonInterfaceVariables.add(varNew);
        VariableImplementation interfaceVariable = VariableImplementation.newInterfaceVariable(var);
        varNew.setInterfaceVariable(interfaceVariable);
        this.interfaceVariables.add(varNew.getVarID(), interfaceVariable);
        return varNew;
    }

    public List<Variable> getListOfDynamicVariables() {
        return this.nonInterfaceVariables;
    }

    public List<Variable> getListOfInterfaceVariables() {
        return this.interfaceVariables;
    }

    public Variable getVariableById(int varID) {
        return this.nonInterfaceVariables.get(varID);
    }

    public Variable getVariableByName(String name) {
        Integer index = this.mapping.get(name);
        if (index == null) {
            throw new UnsupportedOperationException("Variable " + name + " is not part of the list of Variables");
        }
        return this.getVariableById(index);
    }

    public Variable getInterfaceVariableByName(String name) {
        return this.getInterfaceVariable(this.getVariableByName(name));
    }

    public int getNumberOfVars() {
        return this.nonInterfaceVariables.size();
    }

    public void block() {
        for (int i = 0; i < this.interfaceVariables.size(); ++i) {
            VariableImplementation var = (VariableImplementation)this.interfaceVariables.get(i);
            var.setVarID(i + this.getNumberOfVars());
        }
    }

    public List<Variable> getVariablesForListOfAttributes(List<Attribute> attributeList) {
        return attributeList.parallelStream().map(att -> this.getVariableByName(att.getName())).collect(Collectors.toList());
    }

    @Override
    public Iterator<Variable> iterator() {
        return this.nonInterfaceVariables.iterator();
    }

    private static class VariableImplementation
    implements Variable,
    Serializable {
        private static final long serialVersionUID = 7934186475276412196L;
        private String name;
        private int varID;
        private boolean observable;
        private StateSpaceType stateSpaceType;
        private DistributionTypeEnum distributionTypeEnum;
        private DistributionType distributionType;
        private Attribute attribute;
        private final boolean isInterfaceVariable;
        private Variable interfaceVariable;
        private int numberOfStates = -1;

        public VariableImplementation(VariableBuilder builder, int varID) {
            this.name = builder.getName();
            this.varID = varID;
            this.observable = builder.isObservable();
            this.stateSpaceType = builder.getStateSpaceType();
            this.distributionTypeEnum = builder.getDistributionType();
            this.attribute = builder.getAttribute();
            this.isInterfaceVariable = false;
            if (((StateSpaceType)this.getStateSpaceType()).getStateSpaceTypeEnum() == StateSpaceTypeEnum.FINITE_SET) {
                this.numberOfStates = ((FiniteStateSpace)this.stateSpaceType).getNumberOfStates();
            }
            this.distributionType = this.distributionTypeEnum.newDistributionType(this);
        }

        private VariableImplementation(Variable variable) {
            this.name = variable.getName() + DynamicVariables.INTERFACE_SUFFIX;
            this.varID = variable.getVarID();
            this.observable = variable.isObservable();
            this.stateSpaceType = variable.getStateSpaceType();
            this.distributionTypeEnum = variable.getDistributionTypeEnum();
            this.attribute = variable.getAttribute();
            this.isInterfaceVariable = true;
            if (((StateSpaceType)this.getStateSpaceType()).getStateSpaceTypeEnum() == StateSpaceTypeEnum.FINITE_SET) {
                this.numberOfStates = ((FiniteStateSpace)this.stateSpaceType).getNumberOfStates();
            }
            this.distributionType = this.distributionTypeEnum.newDistributionType(this);
        }

        public static VariableImplementation newInterfaceVariable(Variable variable) {
            return new VariableImplementation(variable);
        }

        public void setVarID(int varID) {
            this.varID = varID;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getVarID() {
            return this.varID;
        }

        @Override
        public boolean isObservable() {
            return this.observable;
        }

        @Override
        public <E extends StateSpaceType> E getStateSpaceType() {
            return (E)this.stateSpaceType;
        }

        @Override
        public int getNumberOfStates() {
            return this.numberOfStates;
        }

        @Override
        public DistributionTypeEnum getDistributionTypeEnum() {
            return this.distributionTypeEnum;
        }

        @Override
        public <E extends DistributionType> E getDistributionType() {
            return (E)this.distributionType;
        }

        @Override
        public boolean isInterfaceVariable() {
            return this.isInterfaceVariable;
        }

        @Override
        public Variable getInterfaceVariable() {
            return this.interfaceVariable;
        }

        private void setInterfaceVariable(Variable interfaceVariable_) {
            this.interfaceVariable = interfaceVariable_;
        }

        @Override
        public Attribute getAttribute() {
            return this.attribute;
        }

        public void setAttribute(Attribute att) {
            this.attribute = att;
            this.observable = att != null;
        }

        @Override
        public VariableBuilder getVariableBuilder() {
            VariableBuilder variableBuilder = new VariableBuilder();
            variableBuilder.setAttribute(this.getAttribute());
            variableBuilder.setDistributionType(this.getDistributionTypeEnum());
            variableBuilder.setName(this.getName());
            variableBuilder.setObservable(this.observable);
            variableBuilder.setStateSpaceType((StateSpaceType)this.getStateSpaceType());
            return variableBuilder;
        }

        @Override
        public boolean isDynamicVariable() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable var = (Variable)o;
            return this.isInterfaceVariable() == var.isInterfaceVariable() && this.getVarID() == var.getVarID();
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public boolean isParameterVariable() {
            return false;
        }
    }
}

