% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpc_get_rawdata.R
\name{cpc_get_rawdata}
\alias{cpc_get_rawdata}
\title{Download rainfall data from CPC for the time period of interest}
\usage{
cpc_get_rawdata(begYr, begMo, begDay, endYr, endMo, endDay, usa = FALSE)
}
\arguments{
\item{begYr}{beginning year of the time period of interest, 1979/1948 - present}

\item{begMo}{beginning month of the time period of interest, 1 - 12}

\item{begDay}{beginning day of the time period of interest, 1 - 28/29/30/31}

\item{endYr}{ending year of the time period of interest, 1979/1948 - present}

\item{endMo}{ending month of the time period of interest, 1 - 12}

\item{endDay}{ending day of the time period of interest, 1 - 28/29/30/31}

\item{usa}{logical flag to indicate whether global or usa data is desired}
}
\value{
downloads either a ".gz" file (2008 or before) or a ".bin" file
(2009 - present)
}
\description{
Download rainfall data from CPC for the time period of interest
}
\examples{
\dontrun{
# CPC global data for July 3-5 2014
cpc_get_rawdata(2014, 7, 3, 2014, 7, 5)
# CPC USA data for July 3-5 2014
cpc_get_rawdata(2014, 7, 3, 2014, 7, 5, usa = TRUE)
}
}
\author{
Gopi Goteti
}
