% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dk_activity.R
\name{dk_activity}
\alias{dk_activity}
\title{Time for a radionuclide to decay to a target activity.}
\usage{
dk_activity(A0, half_life, target)
}
\arguments{
\item{A0}{The original activity, or related parameter.}

\item{half_life, }{Half-life. Units are arbitrary, but must match time past.}

\item{target}{The target activity.}
}
\value{
time, in same units as half-life, to decay to target activity.
}
\description{
Calculate time for a radionuclide to decay to a target activity.
}
\examples{
# How long does it take for original activity of 10 to decay to 2.5 
# if half-life is 5? (All time units consistent)
dk_activity(10, 5, 2.5)
}
\seealso{
Other decay corrections: \code{\link{dk_cf}},
  \code{\link{dk_pct_to_num_half_life}},
  \code{\link{dk_reverse}}, \code{\link{dk_time}}
}
\concept{decay corrections}
