% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kclus.R
\name{kclus}
\alias{kclus}
\title{K-clustering}
\usage{
kclus(dataset, vars, fun = "mean", hc_init = TRUE,
  distance = "sq.euclidian", method = "ward.D", seed = 1234,
  nr_clus = 2, standardize = TRUE, data_filter = "")
}
\arguments{
\item{dataset}{Dataset}

\item{vars}{Vector of variables to include in the analysis}

\item{fun}{Function to use: "mean" or "median"}

\item{hc_init}{Use centers from hclus as the starting point}

\item{distance}{Distance for hclus}

\item{method}{Method for hclus}

\item{seed}{Random see to use for k-clustering if hc_init is FALSE}

\item{nr_clus}{Number of clusters to extract}

\item{standardize}{Standardize data (TRUE or FALSE)}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list of all variables used in kclus as an object of class kclus
}
\description{
K-clustering
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/kclus.html} for an example in Radiant
}
\examples{
kclus(shopping, c("v1:v6"), nr_clus = 3) \%>\% str()
}
\seealso{
\code{\link{summary.kclus}} to summarize results

\code{\link{plot.kclus}} to plot results

\code{\link{store.kclus}} to add cluster membership to the selected dataset
}
