% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjoint.R
\name{summary.conjoint}
\alias{summary.conjoint}
\title{Summary method for the conjoint function}
\usage{
\method{summary}{conjoint}(object, show = "", mc_diag = FALSE,
  additional = FALSE, dec = 3, ...)
}
\arguments{
\item{object}{Return value from \code{\link{conjoint}}}

\item{show}{Level in by variable to analyse (e.g., a specific respondent)}

\item{mc_diag}{Shows multicollinearity diagnostics.}

\item{additional}{Show additional regression results}

\item{dec}{Number of decimals to show}

\item{...}{further arguments passed to or from other methods}
}
\description{
Summary method for the conjoint function
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/conjoint.html} for an example in Radiant
}
\examples{
result <- conjoint("mp3", rvar = "Rating", evar = "Memory:Shape")
summary(result, mc_diag = TRUE)
mp3 \%>\% conjoint(rvar = "Rating", evar = "Memory:Shape") \%>\% summary(., mc_diag = TRUE)

}
\seealso{
\code{\link{conjoint}} to generate results

\code{\link{plot.conjoint}} to plot results
}
