% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartesian_to_polar.R
\name{cartesian_to_polar}
\alias{cartesian_to_polar}
\title{Cartesian to Polar Coordinates}
\usage{
cartesian_to_polar(cartesian, anchor = c(0, 0, 0), digits = NULL)
}
\arguments{
\item{cartesian}{A \code{data.table} with three columns describing the *XYZ* coordinates of a point cloud.}

\item{anchor}{A \code{numeric} vector of length three which describe the *XYZ* anchor coordinate for reference to get the polar coordinates. It assumes that the reference coordinates are \code{c(X = 0, Y = 0, Z = 0)} as default.}

\item{digits}{A \code{numeric} vector of length 1 describing the decimal numbers to \code{\link{round}} the zenith and azimuth angles. If \code{NULL}, \code{\link{round}} does not apply. \code{NULL} as default.}
}
\value{
A \code{data.table} with the zenith and azimuth angles (degrees), and the distance to the anchor coordinate.
}
\description{
Convert from East-North-Up cartesian coordinates to polar coordinates.
}
\details{
It assumes that the positive *Z* axis is the reference vector for the zenith angle. Likewise, it assumes that the *Y* axis is the north-south direction (positive to negative) for the azimuth angle.
If a point from \code{cartesian} presents the same *XY* coordinates than \code{anchor}, \code{angles} returns \code{NA}.
}
\examples{

data(pc_tree)
cartesian_to_polar(pc_tree)
anchor <- c(1, 1, 1)
cartesian_to_polar(pc_tree, anchor)

}
\seealso{
\code{\link{polar_to_cartesian}}
}
\author{
J. Antonio Guzmán Q.
}
