% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stand_counting.R
\name{stand_counting}
\alias{stand_counting}
\title{Stand Counting}
\usage{
stand_counting(
  cloud,
  xy.res,
  z.res = NULL,
  points.min = NULL,
  min_size,
  edge_sizes = NULL,
  length_out = 10,
  bootstrap = FALSE,
  R = NULL,
  progress = TRUE,
  parallel = FALSE,
  threads = NULL
)
}
\arguments{
\item{cloud}{A \code{data.table} of a point cloud with xyz coordinates in the first three columns.}

\item{xy.res}{A positive \code{numeric} vector describing the grid resolution of the xy coordinates to perform.}

\item{z.res}{A positive \code{numeric} vector of length 1 describing the vertical resolution. If \code{z.res = NULL} vertical profiles are not used.}

\item{points.min}{A positive \code{numeric} vector of length 1 minimum number of points to retain a sub-grid.}

\item{min_size}{A positive \code{numeric} vector of length 1 describing the minimum cube edge length to perform. This is required if \code{edge_sizes = NULL}.}

\item{edge_sizes}{A positive \code{numeric} vector describing the edge length of the different cubes to perform within each subgrid when \code{z.res = NULL}. If \code{edge_sizes = NULL}, it uses the maximum range of values for the xyz coordinates.}

\item{length_out}{A positive \code{interger} of length 1 indicating the number of different edge lengths to use for each subgrid. This is required if \code{edge_sizes  = NULL}.}

\item{bootstrap}{Logical. If \code{TRUE}, it computes a bootstrap on the H index calculations. \code{FALSE} as default.}

\item{R}{A positive \code{integer} of length 1 indicating the number of bootstrap replicates. This need to be used if \code{bootstrap = TRUE}.}

\item{progress}{Logical, if \code{TRUE} displays a graphical progress bar. \code{TRUE} as default.}

\item{parallel}{Logical, if \code{TRUE} it uses a parallel processing for the voxelization. \code{FALSE} as default.}

\item{threads}{An \code{integer} >= 0 describing the number of threads to use. This need to be used if \code{parallel = TRUE}.}
}
\value{
A \code{data.table} with the summary of the voxels per grid created with their features.
}
\description{
Applies the \code{\link{voxels_counting}} function on a grid base point cloud.
}
\examples{

data(pc_tree)

#Applying stand_counting.
\donttest{
stand_counting(pc_tree, xy.res = c(4, 4), min_size = 3)
}

#Applying stand_counting using bootstrap in the H index.
\donttest{
stand_counting(pc_tree,
               xy.res = c(4, 4),
               min_size = 3,
               bootstrap = TRUE,
               R = 10)
}


}
\seealso{
\code{\link{voxels_counting}}, \code{\link{voxels}}, \code{\link{summary_voxels}}
}
\author{
J. Antonio Guzmán Q.
}
