/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyException;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequenceIter;
import org.python.core.PySlice;
import org.python.core.PyType;
import org.python.core.SequenceIndexDelegate;

public abstract class PySequence
extends PyObject {
    public int gListAllocatedStatus = -1;
    protected final SequenceIndexDelegate delegator = new SequenceIndexDelegate(){

        public String getTypeName() {
            return PySequence.this.getType().fastGetName();
        }

        public void setItem(int idx, PyObject value) {
            PySequence.this.pyset(idx, value);
        }

        public void setSlice(int start, int stop, int step, PyObject value) {
            PySequence.this.setslice(start, stop, step, value);
        }

        public int len() {
            return PySequence.this.__len__();
        }

        public void delItem(int idx) {
            PySequence.this.del(idx);
        }

        public void delItems(int start, int stop) {
            PySequence.this.delRange(start, stop);
        }

        public PyObject getItem(int idx) {
            return PySequence.this.pyget(idx);
        }

        public PyObject getSlice(int start, int stop, int step) {
            return PySequence.this.getslice(start, stop, step);
        }
    };

    public PySequence() {
    }

    protected PySequence(PyType type) {
        super(type);
    }

    protected abstract PyObject pyget(int var1);

    protected abstract PyObject getslice(int var1, int var2, int var3);

    protected abstract PyObject repeat(int var1);

    protected void pyset(int index, PyObject value) {
        throw Py.TypeError("can't assign to immutable object");
    }

    protected void setslice(int start, int stop, int step, PyObject value) {
        throw Py.TypeError(String.format("'%s' object does not support item assignment", this.getType().fastGetName()));
    }

    protected void del(int i) throws PyException {
        throw Py.TypeError(String.format("'%s' object does not support item deletion", this.getType().fastGetName()));
    }

    protected void delRange(int start, int stop) {
        throw Py.TypeError(String.format("'%s' object does not support item deletion", this.getType().fastGetName()));
    }

    public boolean __nonzero__() {
        return this.seq___nonzero__();
    }

    final boolean seq___nonzero__() {
        return this.__len__() != 0;
    }

    public PyObject __iter__() {
        return this.seq___iter__();
    }

    final PyObject seq___iter__() {
        return new PySequenceIter(this);
    }

    public synchronized PyObject __eq__(PyObject o) {
        return this.seq___eq__(o);
    }

    final synchronized PyObject seq___eq__(PyObject o) {
        int ol;
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int tl = this.__len__();
        if (tl != (ol = o.__len__())) {
            return Py.False;
        }
        int i = PySequence.cmp(this, tl, o, ol);
        return i < 0 ? Py.True : Py.False;
    }

    public synchronized PyObject __ne__(PyObject o) {
        return this.seq___ne__(o);
    }

    final synchronized PyObject seq___ne__(PyObject o) {
        int ol;
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int tl = this.__len__();
        if (tl != (ol = o.__len__())) {
            return Py.True;
        }
        int i = PySequence.cmp(this, tl, o, ol);
        return i < 0 ? Py.False : Py.True;
    }

    public synchronized PyObject __lt__(PyObject o) {
        return this.seq___lt__(o);
    }

    final synchronized PyObject seq___lt__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PySequence.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -1 ? Py.True : Py.False;
        }
        return this.__finditem__(i)._lt(o.__finditem__(i));
    }

    public synchronized PyObject __le__(PyObject o) {
        return this.seq___le__(o);
    }

    final synchronized PyObject seq___le__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PySequence.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -1 || i == -2 ? Py.True : Py.False;
        }
        return this.__finditem__(i)._le(o.__finditem__(i));
    }

    public synchronized PyObject __gt__(PyObject o) {
        return this.seq___gt__(o);
    }

    final synchronized PyObject seq___gt__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PySequence.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -3 ? Py.True : Py.False;
        }
        return this.__finditem__(i)._gt(o.__finditem__(i));
    }

    public synchronized PyObject __ge__(PyObject o) {
        return this.seq___ge__(o);
    }

    final synchronized PyObject seq___ge__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PySequence.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -3 || i == -2 ? Py.True : Py.False;
        }
        return this.__finditem__(i)._ge(o.__finditem__(i));
    }

    protected static int cmp(PyObject o1, int ol1, PyObject o2, int ol2) {
        if (ol1 < 0) {
            ol1 = o1.__len__();
        }
        if (ol2 < 0) {
            ol2 = o2.__len__();
        }
        for (int i = 0; i < ol1 && i < ol2; ++i) {
            if (o1.__getitem__(i)._eq(o2.__getitem__(i)).__nonzero__()) continue;
            return i;
        }
        if (ol1 == ol2) {
            return -2;
        }
        return ol1 < ol2 ? -1 : -3;
    }

    protected static PySequence fastSequence(PyObject seq, String msg) {
        if (seq instanceof PySequence) {
            return (PySequence)seq;
        }
        PyList list = new PyList();
        PyObject iter = Py.iter(seq, msg);
        PyObject item = null;
        while ((item = iter.__iternext__()) != null) {
            list.append(item);
        }
        return list;
    }

    protected static final int sliceLength(int start, int stop, long step) {
        int ret = step > 0L ? (int)(((long)(stop - start) + step - 1L) / step) : (int)(((long)(stop - start) + step + 1L) / step);
        if (ret < 0) {
            return 0;
        }
        return ret;
    }

    protected int boundToSequence(int index) {
        int length = this.__len__();
        if (index < 0) {
            index += length;
            if (index < 0) {
                index = 0;
            }
        } else if (index > length) {
            index = length;
        }
        return index;
    }

    public PyObject __finditem__(int index) {
        return this.seq___finditem__(index);
    }

    final synchronized PyObject seq___finditem__(int index) {
        return this.delegator.checkIdxAndFindItem(index);
    }

    public PyObject __finditem__(PyObject index) {
        return this.seq___finditem__(index);
    }

    final PyObject seq___finditem__(PyObject index) {
        return this.delegator.checkIdxAndFindItem(index);
    }

    public PyObject __getitem__(PyObject index) {
        return this.seq___getitem__(index);
    }

    final PyObject seq___getitem__(PyObject index) {
        return this.delegator.checkIdxAndGetItem(index);
    }

    public boolean isMappingType() throws PyIgnoreMethodTag {
        return false;
    }

    public boolean isNumberType() throws PyIgnoreMethodTag {
        return false;
    }

    public synchronized PyObject __getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    final synchronized PyObject seq___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.delegator.getSlice(new PySlice(start, stop, step));
    }

    public synchronized void __setslice__(PyObject start, PyObject stop, PyObject step, PyObject value) {
        this.seq___setslice__(start, stop, step, value);
    }

    final synchronized void seq___setslice__(PyObject start, PyObject stop, PyObject step, PyObject value) {
        if (value == null) {
            value = step;
            step = null;
        }
        this.delegator.checkIdxAndSetSlice(new PySlice(start, stop, step), value);
    }

    public synchronized void __delslice__(PyObject start, PyObject stop, PyObject step) {
        this.seq___delslice__(start, stop, step);
    }

    final synchronized void seq___delslice__(PyObject start, PyObject stop, PyObject step) {
        this.delegator.checkIdxAndDelItem(new PySlice(start, stop, step));
    }

    public synchronized void __setitem__(int index, PyObject value) {
        this.delegator.checkIdxAndSetItem(index, value);
    }

    public void __setitem__(PyObject index, PyObject value) {
        this.seq___setitem__(index, value);
    }

    final void seq___setitem__(PyObject index, PyObject value) {
        this.delegator.checkIdxAndSetItem(index, value);
    }

    public synchronized void __delitem__(PyObject index) {
        this.seq___delitem__(index);
    }

    final synchronized void seq___delitem__(PyObject index) {
        this.delegator.checkIdxAndDelItem(index);
    }

    public synchronized Object __tojava__(Class c) throws PyIgnoreMethodTag {
        if (c.isArray()) {
            Class<?> component = c.getComponentType();
            try {
                int n = this.__len__();
                PyArray array = new PyArray(component, n);
                for (int i = 0; i < n; ++i) {
                    PyObject o = this.pyget(i);
                    array.set(i, o);
                }
                return array.getArray();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.__tojava__(c);
    }

    protected String unsupportedopMessage(String op, PyObject o2) {
        if (op.equals("*")) {
            return "can''t multiply sequence by non-int of type ''{2}''";
        }
        return null;
    }

    protected String runsupportedopMessage(String op, PyObject o2) {
        if (op.equals("*")) {
            return "can''t multiply sequence by non-int of type ''{1}''";
        }
        return null;
    }
}

