/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr;

import java.math.BigInteger;
import java.util.ArrayList;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.Tree;
import org.python.antlr.ErrorHandler;
import org.python.antlr.PythonParser;
import org.python.antlr.PythonTree;
import org.python.antlr.ast.Attribute;
import org.python.antlr.ast.BinOp;
import org.python.antlr.ast.BoolOp;
import org.python.antlr.ast.Call;
import org.python.antlr.ast.ClassDef;
import org.python.antlr.ast.Context;
import org.python.antlr.ast.Expression;
import org.python.antlr.ast.ExtSlice;
import org.python.antlr.ast.For;
import org.python.antlr.ast.FunctionDef;
import org.python.antlr.ast.GeneratorExp;
import org.python.antlr.ast.If;
import org.python.antlr.ast.IfExp;
import org.python.antlr.ast.Index;
import org.python.antlr.ast.Interactive;
import org.python.antlr.ast.Lambda;
import org.python.antlr.ast.List;
import org.python.antlr.ast.ListComp;
import org.python.antlr.ast.Module;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.Num;
import org.python.antlr.ast.Repr;
import org.python.antlr.ast.Slice;
import org.python.antlr.ast.Str;
import org.python.antlr.ast.TryExcept;
import org.python.antlr.ast.TryFinally;
import org.python.antlr.ast.Tuple;
import org.python.antlr.ast.UnaryOp;
import org.python.antlr.ast.While;
import org.python.antlr.ast.Yield;
import org.python.antlr.ast.aliasType;
import org.python.antlr.ast.argumentsType;
import org.python.antlr.ast.boolopType;
import org.python.antlr.ast.cmpopType;
import org.python.antlr.ast.excepthandlerType;
import org.python.antlr.ast.exprType;
import org.python.antlr.ast.expr_contextType;
import org.python.antlr.ast.keywordType;
import org.python.antlr.ast.modType;
import org.python.antlr.ast.operatorType;
import org.python.antlr.ast.sliceType;
import org.python.antlr.ast.stmtType;
import org.python.antlr.ast.unaryopType;
import org.python.core.Py;
import org.python.core.PyComplex;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyString;
import org.python.core.PyUnicode;

public class GrammarActions {
    private ErrorHandler errorHandler = null;

    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    String makeFromText(java.util.List dots, String name) {
        StringBuffer d = new StringBuffer();
        if (dots != null) {
            for (int i = 0; i < dots.size(); ++i) {
                d.append(".");
            }
        }
        if (name != null) {
            d.append(name);
        }
        return d.toString();
    }

    int makeLevel(java.util.List lev) {
        if (lev == null) {
            return 0;
        }
        return lev.size();
    }

    aliasType[] makeStarAlias(Token t) {
        return new aliasType[]{new aliasType(t, "*", null)};
    }

    aliasType[] makeAliases(aliasType[] atypes) {
        if (atypes == null) {
            return new aliasType[0];
        }
        return atypes;
    }

    exprType[] makeBases(exprType etype) {
        if (etype != null) {
            if (etype instanceof Tuple) {
                return ((Tuple)etype).elts;
            }
            return new exprType[]{etype};
        }
        return new exprType[0];
    }

    String[] makeNames(java.util.List names) {
        ArrayList<String> s = new ArrayList<String>();
        for (int i = 0; i < names.size(); ++i) {
            s.add(((Token)names.get(i)).getText());
        }
        return s.toArray(new String[s.size()]);
    }

    void errorGenExpNotSoleArg(PythonTree t) {
        this.errorHandler.error("Generator expression must be parenthesized if not sole argument", t);
    }

    exprType castExpr(Object o) {
        if (o instanceof exprType) {
            return (exprType)o;
        }
        if (o instanceof PythonTree) {
            return this.errorHandler.errorExpr((PythonTree)o);
        }
        return null;
    }

    exprType[] castExprs(java.util.List exprs) {
        return this.castExprs(exprs, 0);
    }

    exprType[] castExprs(java.util.List exprs, int start) {
        if (exprs != null) {
            ArrayList<exprType> result = new ArrayList<exprType>();
            for (int i = start; i < exprs.size(); ++i) {
                Object o = exprs.get(i);
                if (o instanceof exprType) {
                    result.add((exprType)o);
                    continue;
                }
                if (!(o instanceof PythonParser.test_return)) continue;
                result.add((exprType)((PythonParser.test_return)o).tree);
            }
            return result.toArray(new exprType[result.size()]);
        }
        return new exprType[0];
    }

    stmtType[] makeElse(java.util.List elseSuite, PythonTree elif) {
        if (elseSuite != null) {
            return this.castStmts(elseSuite);
        }
        if (elif == null) {
            return new stmtType[0];
        }
        return new stmtType[]{(stmtType)elif};
    }

    stmtType castStmt(Object o) {
        if (o instanceof stmtType) {
            return (stmtType)o;
        }
        if (o instanceof PythonParser.stmt_return) {
            return (stmtType)((PythonParser.stmt_return)o).tree;
        }
        if (o instanceof PythonTree) {
            return this.errorHandler.errorStmt((PythonTree)o);
        }
        return null;
    }

    stmtType[] castStmts(PythonTree t) {
        return new stmtType[]{(stmtType)t};
    }

    stmtType[] castStmts(java.util.List stmts) {
        if (stmts != null) {
            ArrayList<stmtType> result = new ArrayList<stmtType>();
            for (Object o : stmts) {
                result.add(this.castStmt(o));
            }
            return result.toArray(new stmtType[result.size()]);
        }
        return new stmtType[0];
    }

    exprType makeDottedAttr(Token nameToken, java.util.List attrs) {
        exprType current = new Name(nameToken, nameToken.getText(), expr_contextType.Load);
        for (Object o : attrs) {
            Token t = (Token)o;
            current = new Attribute(t, current, t.getText(), expr_contextType.Load);
        }
        return current;
    }

    stmtType makeWhile(Token t, exprType test, java.util.List body, java.util.List orelse) {
        if (test == null) {
            return this.errorHandler.errorStmt(new PythonTree(t));
        }
        stmtType[] o = this.castStmts(orelse);
        stmtType[] b = this.castStmts(body);
        return new While(t, test, b, o);
    }

    stmtType makeFor(Token t, exprType target, exprType iter, java.util.List body, java.util.List orelse) {
        if (target == null || iter == null) {
            return this.errorHandler.errorStmt(new PythonTree(t));
        }
        this.cantBeNone(target);
        stmtType[] o = this.castStmts(orelse);
        stmtType[] b = this.castStmts(body);
        return new For(t, target, iter, b, o);
    }

    stmtType makeTryExcept(Token t, java.util.List body, java.util.List handlers, java.util.List orelse, java.util.List finBody) {
        stmtType[] b = this.castStmts(body);
        excepthandlerType[] e = handlers.toArray(new excepthandlerType[handlers.size()]);
        stmtType[] o = this.castStmts(orelse);
        TryExcept te = new TryExcept(t, b, e, o);
        if (finBody == null) {
            return te;
        }
        stmtType[] f = this.castStmts(finBody);
        stmtType[] mainBody = new stmtType[]{te};
        return new TryFinally(t, mainBody, f);
    }

    TryFinally makeTryFinally(Token t, java.util.List body, java.util.List finBody) {
        stmtType[] b = this.castStmts(body);
        stmtType[] f = this.castStmts(finBody);
        return new TryFinally(t, b, f);
    }

    stmtType makeFuncdef(Token t, Token nameToken, argumentsType args, java.util.List funcStatements, java.util.List decorators) {
        if (nameToken == null) {
            return this.errorHandler.errorStmt(new PythonTree(t));
        }
        this.cantBeNone(nameToken);
        argumentsType a = args != null ? args : new argumentsType(t, new exprType[0], null, null, new exprType[0]);
        stmtType[] s = this.castStmts(funcStatements);
        exprType[] d = this.castExprs(decorators);
        return new FunctionDef(t, nameToken.getText(), a, s, d);
    }

    exprType[] makeAssignTargets(exprType lhs, java.util.List rhs) {
        exprType[] e = new exprType[rhs.size()];
        this.checkAssign(lhs);
        e[0] = lhs;
        for (int i = 0; i < rhs.size() - 1; ++i) {
            exprType r = this.castExpr(rhs.get(i));
            this.checkAssign(r);
            e[i + 1] = r;
        }
        return e;
    }

    exprType makeAssignValue(java.util.List rhs) {
        exprType value = this.castExpr(rhs.get(rhs.size() - 1));
        this.recurseSetContext(value, expr_contextType.Load);
        return value;
    }

    void recurseSetContext(Tree tree, expr_contextType context) {
        if (tree instanceof Context) {
            ((Context)((Object)tree)).setContext(context);
        }
        if (tree instanceof GeneratorExp) {
            GeneratorExp g = (GeneratorExp)tree;
            this.recurseSetContext(g.elt, context);
        } else if (tree instanceof ListComp) {
            ListComp lc = (ListComp)tree;
            this.recurseSetContext(lc.elt, context);
        } else if (!(tree instanceof ListComp)) {
            for (int i = 0; i < tree.getChildCount(); ++i) {
                this.recurseSetContext(tree.getChild(i), context);
            }
        }
    }

    argumentsType makeArgumentsType(Token t, java.util.List params, Token snameToken, Token knameToken, java.util.List defaults) {
        exprType[] p = this.castExprs(params);
        exprType[] d = this.castExprs(defaults);
        String s = snameToken == null ? null : this.cantBeNone(snameToken);
        String k = knameToken == null ? null : this.cantBeNone(knameToken);
        return new argumentsType(t, p, s, k, d);
    }

    exprType[] extractArgs(java.util.List args) {
        return this.castExprs(args);
    }

    keywordType[] makeKeywords(java.util.List args) {
        ArrayList<keywordType> k = new ArrayList<keywordType>();
        if (args != null) {
            for (int i = 0; i < args.size(); ++i) {
                exprType[] e = (exprType[])args.get(i);
                this.checkAssign(e[0]);
                if (e[0] instanceof Name) {
                    Name arg = (Name)e[0];
                    k.add(new keywordType(arg, arg.id, e[1]));
                    continue;
                }
                this.errorHandler.error("keyword must be a name", e[0]);
            }
            return k.toArray(new keywordType[k.size()]);
        }
        return new keywordType[0];
    }

    Object makeFloat(Token t) {
        return Py.newFloat(Double.valueOf(t.getText()));
    }

    Object makeComplex(Token t) {
        String s = t.getText();
        s = s.substring(0, s.length() - 1);
        return Py.newImaginary(Double.valueOf(s));
    }

    Object makeInt(Token t) {
        int i;
        String s = t.getText();
        int radix = 10;
        if (s.startsWith("0x") || s.startsWith("0X")) {
            radix = 16;
            s = s.substring(2, s.length());
        } else if (s.startsWith("0")) {
            radix = 8;
        }
        if (s.endsWith("L") || s.endsWith("l")) {
            s = s.substring(0, s.length() - 1);
            return Py.newLong(new BigInteger(s, radix));
        }
        int ndigits = s.length();
        for (i = 0; i < ndigits && s.charAt(i) == '0'; ++i) {
        }
        if (ndigits - i > 11) {
            return Py.newLong(new BigInteger(s, radix));
        }
        long l = Long.valueOf(s, radix);
        if (l > 0xFFFFFFFFL || l > Integer.MAX_VALUE) {
            return Py.newLong(new BigInteger(s, radix));
        }
        return Py.newInteger((int)l);
    }

    PyString extractStrings(java.util.List s) {
        boolean ustring = false;
        Token last2 = null;
        StringBuffer sb = new StringBuffer();
        for (Token last2 : s) {
            StringPair sp = this.extractString(last2);
            if (sp.isUnicode()) {
                ustring = true;
            }
            sb.append(sp.getString());
        }
        if (ustring) {
            return new PyUnicode(sb.toString());
        }
        return new PyString(sb.toString());
    }

    StringPair extractString(Token t) {
        int i;
        String s = t.getText();
        char quoteChar = s.charAt(0);
        int start = 0;
        boolean ustring = false;
        if (quoteChar == 'u' || quoteChar == 'U') {
            ustring = true;
            ++start;
        }
        quoteChar = s.charAt(start);
        boolean raw = false;
        if (quoteChar == 'r' || quoteChar == 'R') {
            raw = true;
            ++start;
        }
        int quotes = 3;
        if (s.length() - start == 2) {
            quotes = 1;
        }
        if (s.charAt(start) != s.charAt(start + 1)) {
            quotes = 1;
        }
        if (raw) {
            return new StringPair(s.substring(quotes + start, s.length() - quotes), ustring);
        }
        StringBuffer sb = new StringBuffer(s.length());
        char[] ca = s.toCharArray();
        int n = ca.length - quotes;
        int last_i = i = quotes + start;
        return new StringPair(PyString.decode_UnicodeEscape(s, i, n, "strict", ustring), ustring);
    }

    Token extractStringToken(java.util.List s) {
        return (Token)s.get(0);
    }

    modType makeMod(PythonTree t, java.util.List stmts) {
        stmtType[] s = this.castStmts(stmts);
        return new Module(t, s);
    }

    modType makeExpression(PythonTree t, exprType e) {
        return new Expression(t, e);
    }

    modType makeInteractive(PythonTree t, java.util.List stmts) {
        stmtType[] s = this.castStmts(stmts);
        return new Interactive(t, s);
    }

    stmtType makeClassDef(PythonTree t, PythonTree nameToken, java.util.List bases, java.util.List body, java.util.List decorators) {
        if (nameToken == null) {
            return this.errorHandler.errorStmt(t);
        }
        this.cantBeNone(nameToken);
        exprType[] b = this.castExprs(bases);
        stmtType[] s = this.castStmts(body);
        exprType[] d = this.castExprs(decorators);
        return new ClassDef(t, nameToken.getText(), b, s, d);
    }

    stmtType makeTryExcept(PythonTree t, java.util.List body, java.util.List handlers, java.util.List orelse, java.util.List finBody) {
        stmtType[] b = this.castStmts(body);
        excepthandlerType[] e = handlers.toArray(new excepthandlerType[handlers.size()]);
        stmtType[] o = this.castStmts(orelse);
        TryExcept te = new TryExcept(t, b, e, o);
        if (finBody == null) {
            return te;
        }
        stmtType[] f = this.castStmts(finBody);
        stmtType[] mainBody = new stmtType[]{te};
        return new TryFinally(t, mainBody, f);
    }

    TryFinally makeTryFinally(PythonTree t, java.util.List body, java.util.List finBody) {
        stmtType[] b = this.castStmts(body);
        stmtType[] f = this.castStmts(finBody);
        return new TryFinally(t, b, f);
    }

    stmtType makeIf(PythonTree t, exprType test, java.util.List body, java.util.List orelse) {
        if (test == null) {
            return this.errorHandler.errorStmt(t);
        }
        stmtType[] o = this.castStmts(orelse);
        stmtType[] b = this.castStmts(body);
        return new If(t, test, b, o);
    }

    stmtType makeWhile(PythonTree t, exprType test, java.util.List body, java.util.List orelse) {
        if (test == null) {
            return this.errorHandler.errorStmt(t);
        }
        stmtType[] o = this.castStmts(orelse);
        stmtType[] b = this.castStmts(body);
        return new While(t, test, b, o);
    }

    stmtType makeFor(PythonTree t, exprType target, exprType iter, java.util.List body, java.util.List orelse) {
        if (target == null || iter == null) {
            return this.errorHandler.errorStmt(t);
        }
        this.cantBeNone(target);
        stmtType[] o = this.castStmts(orelse);
        stmtType[] b = this.castStmts(body);
        return new For(t, target, iter, b, o);
    }

    exprType makeCall(Token t, exprType func) {
        return this.makeCall(t, func, null, null, null, null);
    }

    exprType makeCall(Token t, exprType func, java.util.List args, java.util.List keywords, exprType starargs, exprType kwargs) {
        if (func == null) {
            return this.errorHandler.errorExpr(new PythonTree(t));
        }
        keywordType[] k = this.makeKeywords(keywords);
        exprType[] a = this.castExprs(args);
        return new Call(t, func, a, k, starargs, kwargs);
    }

    exprType negate(Token t, exprType o) {
        return this.negate(new PythonTree(t), o);
    }

    exprType negate(PythonTree t, exprType o) {
        if (o instanceof Num) {
            double v;
            Num num = (Num)o;
            if (num.n instanceof PyInteger) {
                int v2 = ((PyInteger)num.n).getValue();
                if (v2 > 0) {
                    num.n = new PyInteger(-v2);
                    return num;
                }
            } else if (num.n instanceof PyLong) {
                BigInteger v3 = ((PyLong)num.n).getValue();
                if (v3.compareTo(BigInteger.ZERO) == 1) {
                    num.n = new PyLong(v3.negate());
                    return num;
                }
            } else if (num.n instanceof PyFloat) {
                double v4 = ((PyFloat)num.n).getValue();
                if (v4 > 0.0) {
                    num.n = new PyFloat(-v4);
                    return num;
                }
            } else if (num.n instanceof PyComplex && (v = ((PyComplex)num.n).imag) > 0.0) {
                num.n = new PyComplex(0.0, -v);
                return num;
            }
        }
        return new UnaryOp(t, unaryopType.USub, o);
    }

    String cantBeNone(Token t) {
        if (t == null || t.getText().equals("None")) {
            this.errorHandler.error("can't be None", new PythonTree(t));
        }
        return t.getText();
    }

    void cantBeNone(PythonTree e) {
        if (e.getText().equals("None")) {
            this.errorHandler.error("can't be None", e);
        }
    }

    void checkAssign(exprType e) {
        block4: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block3: {
                                                        if (!(e instanceof Name) || !((Name)e).id.equals("None")) break block3;
                                                        this.errorHandler.error("assignment to None", e);
                                                        break block4;
                                                    }
                                                    if (!(e instanceof GeneratorExp)) break block5;
                                                    this.errorHandler.error("can't assign to generator expression", e);
                                                    break block4;
                                                }
                                                if (!(e instanceof Num)) break block6;
                                                this.errorHandler.error("can't assign to number", e);
                                                break block4;
                                            }
                                            if (!(e instanceof Str)) break block7;
                                            this.errorHandler.error("can't assign to string", e);
                                            break block4;
                                        }
                                        if (!(e instanceof Yield)) break block8;
                                        this.errorHandler.error("can't assign to yield expression", e);
                                        break block4;
                                    }
                                    if (!(e instanceof BinOp)) break block9;
                                    this.errorHandler.error("can't assign to operator", e);
                                    break block4;
                                }
                                if (!(e instanceof Lambda)) break block10;
                                this.errorHandler.error("can't assign to lambda", e);
                                break block4;
                            }
                            if (!(e instanceof Call)) break block11;
                            this.errorHandler.error("can't assign to function call", e);
                            break block4;
                        }
                        if (!(e instanceof Repr)) break block12;
                        this.errorHandler.error("can't assign to repr", e);
                        break block4;
                    }
                    if (!(e instanceof IfExp)) break block13;
                    this.errorHandler.error("can't assign to conditional expression", e);
                    break block4;
                }
                if (!(e instanceof Tuple)) break block14;
                exprType[] elts = ((Tuple)e).elts;
                if (elts.length == 0) {
                    this.errorHandler.error("can't assign to ()", e);
                }
                for (int i = 0; i < elts.length; ++i) {
                    this.checkAssign(elts[i]);
                }
                break block4;
            }
            if (!(e instanceof List)) break block4;
            exprType[] elts = ((List)e).elts;
            for (int i = 0; i < elts.length; ++i) {
                this.checkAssign(elts[i]);
            }
        }
    }

    exprType[] makeDeleteList(java.util.List e) {
        exprType[] exprs = this.castExprs(e);
        for (int i = 0; i < exprs.length; ++i) {
            if (!(exprs[i] instanceof Call)) continue;
            this.errorHandler.error("can't delete function call", exprs[i]);
        }
        return exprs;
    }

    sliceType makeSubscript(PythonTree lower, Token colon, PythonTree upper, PythonTree sliceop) {
        boolean isSlice = false;
        exprType s = null;
        exprType e = null;
        exprType o = null;
        if (lower != null) {
            s = this.castExpr(lower);
        }
        if (colon != null) {
            isSlice = true;
            if (upper != null) {
                e = this.castExpr(upper);
            }
        }
        if (sliceop != null) {
            isSlice = true;
            o = sliceop != null ? this.castExpr(sliceop) : new Name(sliceop, "None", expr_contextType.Load);
        }
        PythonTree tok = lower;
        if (lower == null) {
            tok = new PythonTree(colon);
        }
        if (isSlice) {
            return new Slice(tok, s, e, o);
        }
        return new Index(tok, s);
    }

    cmpopType[] makeCmpOps(java.util.List cmps) {
        if (cmps != null) {
            ArrayList<cmpopType> result = new ArrayList<cmpopType>();
            for (Object o : cmps) {
                result.add((cmpopType)o);
            }
            return result.toArray(new cmpopType[result.size()]);
        }
        return new cmpopType[0];
    }

    BoolOp makeBoolOp(PythonTree left, boolopType op, java.util.List right) {
        ArrayList<PythonTree> values = new ArrayList<PythonTree>();
        values.add(left);
        values.addAll(right);
        return new BoolOp(left, op, this.castExprs(values));
    }

    BinOp makeBinOp(PythonTree left, operatorType op, java.util.List rights) {
        BinOp current = new BinOp(left, this.castExpr(left), op, this.castExpr(rights.get(0)));
        for (int i = 1; i < rights.size(); ++i) {
            exprType right = this.castExpr(rights.get(i));
            current = new BinOp(left, (exprType)current, op, right);
        }
        return current;
    }

    BinOp makeBinOp(PythonTree left, java.util.List ops, java.util.List rights) {
        BinOp current = new BinOp(left, this.castExpr(left), (operatorType)ops.get(0), this.castExpr(rights.get(0)));
        for (int i = 1; i < rights.size(); ++i) {
            exprType right = this.castExpr(rights.get(i));
            operatorType op = (operatorType)ops.get(i);
            current = new BinOp(left, (exprType)current, op, right);
        }
        return current;
    }

    sliceType[] castSlices(java.util.List slices) {
        if (slices != null) {
            ArrayList<sliceType> result = new ArrayList<sliceType>();
            for (Object o : slices) {
                result.add(this.castSlice(o));
            }
            return result.toArray(new sliceType[result.size()]);
        }
        return new sliceType[0];
    }

    sliceType castSlice(Object o) {
        if (o instanceof sliceType) {
            return (sliceType)o;
        }
        return this.errorHandler.errorSlice((PythonTree)o);
    }

    sliceType makeSliceType(Token begin, Token c1, Token c2, java.util.List sltypes) {
        boolean isTuple = false;
        if (c1 != null || c2 != null) {
            isTuple = true;
        }
        sliceType s = null;
        boolean extslice = false;
        if (isTuple) {
            ArrayList<exprType> etypes = new ArrayList<exprType>();
            for (Object o : sltypes) {
                if (o instanceof Index) {
                    Index i = (Index)o;
                    etypes.add(i.value);
                    continue;
                }
                extslice = true;
                break;
            }
            if (!extslice) {
                exprType[] es = etypes.toArray(new exprType[etypes.size()]);
                Tuple t = new Tuple(begin, es, expr_contextType.Load);
                s = new Index(begin, (exprType)t);
            }
        } else if (sltypes.size() == 1) {
            s = this.castSlice(sltypes.get(0));
        } else if (sltypes.size() != 0) {
            extslice = true;
        }
        if (extslice) {
            sliceType[] st = this.castSlices(sltypes);
            s = new ExtSlice(begin, st);
        }
        return s;
    }

    class StringPair {
        private String s;
        private boolean unicode;

        StringPair(String s, boolean unicode) {
            this.s = s;
            this.unicode = unicode;
        }

        String getString() {
            return this.s;
        }

        boolean isUnicode() {
            return this.unicode;
        }
    }
}

