% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_elev_prof.R
\name{get_elev_prof}
\alias{get_elev_prof}
\alias{get_elev_prof.list}
\alias{get_elev_prof.actframe}
\alias{get_elev_prof.strframe}
\title{Create elevation profiles from activity data}
\usage{
get_elev_prof(act_data, ...)

\method{get_elev_prof}{list}(
  act_data,
  acts = 1,
  id = NULL,
  key,
  total = FALSE,
  expand = 10,
  units = "metric",
  fill = "darkblue",
  ...
)

\method{get_elev_prof}{actframe}(
  act_data,
  key,
  total = FALSE,
  expand = 10,
  fill = "darkblue",
  ...
)

\method{get_elev_prof}{strframe}(act_data, total = FALSE, expand = 10, fill = "darkblue", ...)
}
\arguments{
\item{act_data}{an activities list object returned by \code{\link{get_activity_list}} or a \code{data.frame} returned by \code{\link{compile_activities}}}

\item{...}{arguments passed to or from other methods}

\item{acts}{numeric value indicating which elements of \code{act_data} to plot, defaults to most recent}

\item{id}{optional numeric vector to specify the id(s) of the activity/activities to plot, \code{acts} is ignored if provided}

\item{key}{chr string of Google API key for elevation data, passed to \code{\link[googleway]{google_elevation}}, see details}

\item{total}{logical indicating if elevations are plotted as cumulative climbed by distance}

\item{expand}{a numeric multiplier for expanding the number of lat/lon points on straight lines.  This can create a smoother elevation profile. Set \code{expand = 1} to suppress this behavior.}

\item{units}{chr string indicating plot units as either metric or imperial, this has no effect if input data are already compiled with \code{\link{compile_activities}}}

\item{fill}{chr string of fill color for profile}
}
\value{
A \code{ggplot} of elevation profiles, facetted by activity id, date
}
\description{
Create elevation profiles from activity data
}
\details{
The Google API key is easy to obtain, follow instructions here: https://developers.google.com/maps/documentation/elevation/#api_key
}
\examples{
\dontrun{
# get my activities
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, app_secret, cache = TRUE))
my_acts <- get_activity_list(stoken)

# your unique key
mykey <- 'Get Google API key'
get_elev_prof(my_acts, acts = 1:2, key = mykey)

# compile first, change units
my_acts <- compile_activities(my_acts, acts = c(1:2), units = 'imperial')
get_elev_prof(my_acts, key = mykey)
}
}
\seealso{
\code{\link{get_dists}}
}
\author{
Daniel Padfield, Marcus Beck
}
\concept{token}
