% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_streams.R
\name{get_streams}
\alias{get_streams}
\title{Retrieve a Strava data stream for a single activity}
\usage{
get_streams(
  stoken,
  id,
  request = "activities",
  types = NULL,
  resolution = NULL,
  series_type = NULL
)
}
\arguments{
\item{stoken}{A \code{\link[httr]{config}} object created using the \code{\link{strava_oauth}} function}

\item{id}{numeric for id of the request}

\item{request}{chr string defining the stream type, must be "activities", "segment_efforts", "segments"}

\item{types}{list of chr strings with any combination of "time", "latlng", "distance", "altitude", "velocity_smooth", "heartrate", "cadence", "watts", "temp", "moving", or "grade_smooth"}

\item{resolution}{chr string for the data resolution to retrieve, can be "low", "medium", "high", defaults to all}

\item{series_type}{chr string for merging the data if \code{resolution} is not equal to "all".  Accepted values are "distance" (default) or "time".}
}
\value{
Data from an API request.
}
\description{
Retrieve a Strava data stream for a single activity.
Internally called by \code{\link{get_activity_streams}}.
}
\details{
Requires authentication stoken using the \code{\link{strava_oauth}} function and a user-created API on the strava website. From the API documentation, 'streams' is the Strava term for the raw data associated with an activity.
}
\examples{
\dontrun{
# create authentication token
# requires user created app name, id, and secret from Strava website
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, 
	app_secret, cache = TRUE))

get_streams(stoken, id = 351217692, types = list('distance', 'latlng'))
}
}
\concept{token}
