% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inla_rspde.R
\name{graph_data_rspde}
\alias{graph_data_rspde}
\title{Data extraction from metric graphs for 'rSPDE' models}
\usage{
graph_data_rspde(
  graph_rspde,
  name = "field",
  repl = NULL,
  group = NULL,
  group_col = NULL,
  only_pred = FALSE,
  loc = NULL,
  loc_name = NULL,
  tibble = FALSE,
  drop_na = FALSE,
  drop_all_na = TRUE
)
}
\arguments{
\item{graph_rspde}{An \code{inla_metric_graph_spde} object built with the
\code{rspde.metric_graph()} function.}

\item{name}{A character string with the base name of the effect.}

\item{repl}{Which replicates? If there is no replicates, one
can set \code{repl} to \code{NULL}. If one wants all replicates,
then one sets to \code{repl} to \code{.all}.}

\item{group}{Which groups? If there is no groups, one
can set \code{group} to \code{NULL}. If one wants all groups,
then one sets to \code{group} to \code{.all}.}

\item{group_col}{Which "column" of the data contains the group variable?}

\item{only_pred}{Should only return the \code{data.frame} to the prediction data?}

\item{loc}{Locations. If not given, they will be chosen as the available locations on the metric graph internal dataset.}

\item{loc_name}{Character with the name of the location variable to be used in
'inlabru' prediction.}

\item{tibble}{Should the data be returned as a \code{tidyr::tibble}?}

\item{drop_na}{Should the rows with at least one NA for one of the columns be removed? DEFAULT is \code{FALSE}. This option is turned to \code{FALSE} if \code{only_pred} is \code{TRUE}.}

\item{drop_all_na}{Should the rows with all variables being NA be removed? DEFAULT is \code{TRUE}. This option is turned to \code{FALSE} if \code{only_pred} is \code{TRUE}.}
}
\value{
An 'INLA' and 'inlabru' friendly list with the data.
}
\description{
Extracts data from metric graphs to be used by 'INLA' and 'inlabru'.
}
