% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inla_rspde.R
\name{rspde.mesh.project}
\alias{rspde.mesh.project}
\alias{rspde.mesh.projector}
\alias{rspde.mesh.project.inla.mesh}
\alias{rspde.mesh.project.rspde.mesh.projector}
\alias{rspde.mesh.project.inla.mesh.1d}
\title{Calculate a lattice projection to/from an \code{inla.mesh} for
rSPDE objects}
\usage{
rspde.mesh.project(...)

rspde.mesh.projector(
  mesh,
  nu = NULL,
  rspde_order = 2,
  loc = NULL,
  lattice = NULL,
  xlim = NULL,
  ylim = NULL,
  dims = c(100, 100),
  projection = NULL,
  ...
)

\method{rspde.mesh.project}{inla.mesh}(
  mesh,
  loc = NULL,
  field = NULL,
  rspde_order = 2,
  nu = NULL,
  ...
)

\method{rspde.mesh.project}{rspde.mesh.projector}(projector, field, ...)

\method{rspde.mesh.project}{inla.mesh.1d}(mesh, loc, field = NULL, rspde_order = 2, nu = NULL, ...)
}
\arguments{
\item{...}{Additional parameters.}

\item{mesh}{An \code{inla.mesh} or \code{inla.mesh.1d} object.}

\item{nu}{The smoothness parameter. If \code{NULL}, it will be assumed that
nu was estimated.}

\item{rspde_order}{The order of the rational approximation.}

\item{loc}{Projection locations. Can be a matrix or a SpatialPoints or a
SpatialPointsDataFrame object.}

\item{lattice}{An \code{inla.mesh.lattice} object.}

\item{xlim}{X-axis limits for a lattice. For R2 meshes, defaults to covering
the domain.}

\item{ylim}{Y-axis limits for a lattice. For R2 meshes, defaults to covering
the domain.}

\item{dims}{Lattice dimensions.}

\item{projection}{One of c("default", "longlat", "longsinlat", "mollweide").}

\item{field}{Basis function weights, one per mesh basis function, describing
the function to be evaluated at the projection locations.}

\item{projector}{A \code{rspde.mesh.projector} object.}
}
\value{
A list with projection information for rspde.mesh.project. For
rspde.mesh.projector(mesh, ...),
a rspde.mesh.projector object. For rspde.mesh.project(projector, field, ...),
a field projected from the mesh onto the locations
given by the projector object.
}
\description{
Calculate a lattice projection to/from an \code{inla.mesh} for
rSPDE objects
}
\details{
This function is built upon the inla.mesh.project and
inla.mesh.projector functions from INLA.
}
