% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/show-pref.r
\name{show.pref}
\alias{eval.pref}
\alias{pref.str}
\alias{show.pref}
\title{Partial Evaluation and String/Expression Output of Preferences}
\usage{
show.pref(p, df = NULL)

pref.str(p, df = NULL)

eval.pref(p, df = NULL)
}
\arguments{
\item{p}{The preference to be shown or partially evaluated.}

\item{df}{(optional) A data frame on which the preference operates.}
}
\description{
Functions to substitute variables and functions in preferences
which can be calculated before the preference is evaluated on a data frame.
This is especially used for the string/expression output of preferences.
}
\details{
The function \code{pref.str} (or \code{as.character(p)} for a preference \code{p}) returns the preference string
while \code{show.pref} outputs it directly to the console, preceded by \code{'[Preference]'}.
If \code{df} is specified, then a partial evaluation of the preference is done before converting it to a string.
With \code{as.expression(p)} the R code for constructing a given preference is given.

The function \code{eval.pref} (with given data frame \code{df}) partially evaluates the internal preference expression and
returns again a preference object. All expressions in \code{p} are evaluated in the environment
where \code{p} was defined, except the the column names in \code{df} (which are potential attributes in \code{p})
and except the special variable \code{df__}, which accesses the entire data set (see \code{\link{psel}}).
The content of the data frame \code{df} does not matter; only \code{names(df)} is used to get the "free variables" in \code{p}.
}
\section{Partial Evaluation Before String Output}{


The functions \code{show.pref} and \code{pref.str} have the optional parameter \code{df}.
If this parameter is given, these functions call \code{eval.pref} before they output or return the preference string.
The following equalities hold:

\itemize{
  \item \code{as.character(eval.pref(p, df)) == pref.str(p, df)}
  \item \code{show(eval.pref(p, df))} produces the same console output as \code{show.pref(p, df)}
}
}
\examples{
f <- function(x) 2*x
p <- true(cyl == f(1))

# prints 'true(cyl == f(1))'
p

# prints 'true(cyl == 2)'
show.pref(p, mtcars)
eval.pref(p, mtcars)
}
\seealso{
See \code{\link{general_pref}} for more utility functions for preferences.
}

