% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{compose_metadata_query}
\alias{compose_metadata_query}
\title{Compose a query to fetch metadata from the Kolada API.}
\usage{
compose_metadata_query(
  entity = "kpi",
  title = NULL,
  id = NULL,
  municipality = NULL,
  version = "v2"
)
}
\arguments{
\item{entity}{Any allowed metadata entity. Check
\code{\link{allowed_entities}} to see an updated list.}

\item{title}{A free-form search term or the exact title of any entry in the
current entity. Case insensitive.}

\item{id}{The ID of any entry in the current entity.}

\item{municipality}{If entity is \code{"ou"}, the municipality parameter can
be added to narrow the search.}

\item{version}{Version of the API. Currently only \code{"v2"} is supported.}
}
\value{
A string containing a URL to the Kolada REST API.
}
\description{
Mainly used as a supporting function for \code{\link{get_metadata}} but can
also be used to create a working URL to paste in your web browser.
}
