\name{score}
\alias{score}
\alias{score,EMM,numeric-method}
\alias{score,EMM,data.frame-method}
\alias{score,EMM,matrix-method}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Score a New Sequence Given an EMM}
\description{
Calculates a score of how likely it is that a new sequence was generated
by the same process as the sequences used to build the EMM.
}
\usage{
\S4method{score}{EMM,matrix}(x, newdata, method = c("prod", "sum", "log_odds"), match_state = "nn", plus_one=TRUE, initial_transition = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{ an \code{EMM} object. }
  \item{newdata}{ sequence to score }
  \item{method}{ method to calculate the score (see details) }
  \item{match_state}{ do the new observations have to fall within
    the threshold of state (\code{"exact"}) or is nearest neighbor 
    used (\code{"nn"})?}
  \item{plus_one}{ add one to each transition count. This is equal
      to start with one for each transition count, i.e. initially all
          transitions are equally likely. It prevents the product
          of probabilities to be zero if a transition was never observed. }
  \item{initial_transition}{ include the initial transition 
         in the computation?}
}
\details{
A score of how likely it is that a sequence was generated by a given EMM model
can be calculated by the length-normalized product or sum of probabilities on
the path along the new sequence.
The scores for a new sequence of length \eqn{l} are defined as:

\deqn{P_\mathrm{prod} = \sqrt[l-1]{\prod_{i=1}^{l-1}{a_{s(i),s(i+1)}}}}{
	P_prod = prod(a_s(i),s(i+1))^(1/(l-1))}

\deqn{P_\mathrm{sum} = \frac{1}{l-1} \sum_{i=1}^{l-1}{a_{s(i),s(i+1)}}}{
	P_sum = 1/(l-1) sum(a_s(i),s(i+1))}

where \eqn{a_{ij}}{a_ij} is the transition probability from state \eqn{i}
to state \eqn{j} and
\eqn{s(i)} is the state the \eqn{i}th data point in
the new sequence is assigned to.
}
\value{
    A scalar score value.
}
%\references{ ~put references to the literature/web site here ~ }
%\author{ ~~who you are~~ }
\seealso{\code{\link{transition}} to access transition probabilities
and \code{\link{find_states}} for assigning observations to states/clusters. }
\examples{
data("EMMsim")

emm <- EMM(threshold=.5)
emm <- build(emm, EMMsim_train)

score(emm, EMMsim_test)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
