% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/confusion_matrix.R
\name{sensitivity}
\alias{confusion_matrix}
\alias{sensitivity}
\alias{specificity}
\title{Sensitivity, Specificity, and Confusion Matrices (Contingency Tables)}
\usage{
sensitivity(tab, ...)

specificity(tab, ...)

confusion_matrix(formula, data, boot = FALSE, boot_samples = 1000L,
  alpha = 0.05)
}
\arguments{
\item{tab}{A 2-by-2 confusion_matrix matrix or ftable}

\item{...}{not currently used}

\item{formula}{column ~ row for building the confusion matrix}

\item{data}{environment containing the variables listed in the formula}

\item{boot}{boolean, should bootstrapped confidence intervals for the
sensitivity and specificity be computed?  Defaults to FALSE.}

\item{boot_samples}{number of bootstrapping sample to generate, defaults to
1000L.  Ignored if \code{boot == FALSE}.}

\item{alpha}{100(1-alpha)% confidence intervals for specificity and
sensitivity.  Ignored if \code{boot == FALSE}.}
}
\value{
The sensitivity and specificity functions return numeric values.
\code{confusion_matrix} returns a list with elements:
\itemize{
  \item tab the confusion matrix,
  \item specificity point estimate for specificity,
  \item sensitivity point estimate for sensitivity,
  \item specificity_ci bootstrapped confidence interval for specificity, and
  \item sensitivity_ci bootstrapped confidence interval for sensitivity.
}
}
\description{
Functions for calculating the sensitivity and specificity, along
with bootstrapped confidence intervals, of confusion matrices (contingency
tables).
}
\details{
Sensitivity and Specificity:
For the sensitivity and specificity function we expect the 2-by-2 confusion
matrix (contingency table) to be of the form:

\tabular{lccc}{
                    \tab      \tab True \tab Condition \cr
                    \tab      \tab -    \tab +         \cr
Predicted Condition \tab -    \tab TN   \tab FN        \cr
Predicted Condition \tab +    \tab FP   \tab TP        \cr
}
where
\itemize{
  \item TN: True Negative,
  \item FP: False Positive,
  \item FN: False Negative, and
  \item TP: True Positive.
}

sensitivity = TP / (TP + FN)
specificity = TN / (TN + FP)

This table set up is the result of using 0/1 or boolean variables. See
examples.
}
\examples{
## Does knowing if a diamond is more than 1.5 carats in weight tell us if the
## price is more than $5,000?

data("diamonds", package = "ggplot2")

x <- ftable(I(price > 5000) ~ I(carat > 1.5), data = diamonds)

sensitivity(x)
specificity(x)

sensitivity(I(price > 5000) ~ I(carat > 1.5), data = diamonds)
specificity(I(price > 5000) ~ I(carat > 1.5), data = diamonds)

confusion_matrix(I(price > 5000) ~ I(carat > 1.5), data = diamonds)
print(confusion_matrix(I(price > 5000) ~ I(carat > 1.5), data = diamonds), digits = 4)

\donttest{
x <- confusion_matrix(I(price > 5000) ~ I(carat > 1.5),
                      data = diamonds,
                      boot = TRUE,
                      boot_samples = 100L)
print(x, digits = 4)
}
}

